/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.OidcMetadata;
import org.cloudfoundry.identity.uaa.provider.oauth.OidcMetadataFetchingException;
import org.springframework.web.client.RestTemplate;

public class OidcMetadataFetcher {
    private final UrlContentCache contentCache;
    private final RestTemplate trustingRestTemplate;
    private final RestTemplate nonTrustingRestTemplate;

    public OidcMetadataFetcher(UrlContentCache contentCache, RestTemplate trustingRestTemplate, RestTemplate nonTrustingRestTemplate) {
        this.contentCache = contentCache;
        this.trustingRestTemplate = trustingRestTemplate;
        this.nonTrustingRestTemplate = nonTrustingRestTemplate;
    }

    public void fetchMetadataAndUpdateDefinition(OIDCIdentityProviderDefinition definition) throws OidcMetadataFetchingException {
        if (this.shouldFetchMetadata(definition)) {
            OidcMetadata oidcMetadata = this.fetchMetadata(definition.getDiscoveryUrl(), definition.isSkipSslValidation());
            this.updateIdpDefinition(definition, oidcMetadata);
        }
    }

    private OidcMetadata fetchMetadata(URL discoveryUrl, boolean shouldDoSslValidation) throws OidcMetadataFetchingException {
        byte[] rawContents = shouldDoSslValidation ? this.contentCache.getUrlContent(discoveryUrl.toString(), this.trustingRestTemplate) : this.contentCache.getUrlContent(discoveryUrl.toString(), this.nonTrustingRestTemplate);
        try {
            return (OidcMetadata)new ObjectMapper().readValue(rawContents, OidcMetadata.class);
        }
        catch (IOException e) {
            throw new OidcMetadataFetchingException(e);
        }
    }

    private void updateIdpDefinition(OIDCIdentityProviderDefinition definition, OidcMetadata oidcMetadata) {
        definition.setAuthUrl(Optional.ofNullable(definition.getAuthUrl()).orElse(oidcMetadata.getAuthorizationEndpoint()));
        definition.setTokenUrl(Optional.ofNullable(definition.getTokenUrl()).orElse(oidcMetadata.getTokenEndpoint()));
        definition.setTokenKeyUrl(Optional.ofNullable(definition.getTokenKeyUrl()).orElse(oidcMetadata.getJsonWebKeysUri()));
        definition.setUserInfoUrl(Optional.ofNullable(definition.getUserInfoUrl()).orElse(oidcMetadata.getUserinfoEndpoint()));
        definition.setIssuer(Optional.ofNullable(definition.getIssuer()).orElse(oidcMetadata.getIssuer()));
    }

    private boolean shouldFetchMetadata(OIDCIdentityProviderDefinition definition) {
        return definition.getDiscoveryUrl() != null && !StringUtils.isBlank((CharSequence)definition.getDiscoveryUrl().toString());
    }
}

