/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class Saml2TokenGranter
extends AbstractTokenGranter {
    private static final Log logger = LogFactory.getLog(Saml2TokenGranter.class);

    public Saml2TokenGranter(AuthorizationServerTokenServices tokenServices, ClientServicesExtension clientDetailsService, OAuth2RequestFactory requestFactory) {
        super(tokenServices, (ClientDetailsService)clientDetailsService, requestFactory, "urn:ietf:params:oauth:grant-type:saml2-bearer");
    }

    public OAuth2AccessToken grant(String grantType, TokenRequest tokenRequest) {
        TokenRequest adjusted = new TokenRequest(tokenRequest.getRequestParameters(), tokenRequest.getClientId(), (Collection)tokenRequest.getScope(), tokenRequest.getGrantType());
        return super.grant(grantType, adjusted);
    }

    protected Authentication validateRequest(TokenRequest request) {
        if (request == null || request.getRequestParameters() == null) {
            throw new InvalidGrantException("Missing token request object");
        }
        if (request.getRequestParameters().get("grant_type") == null) {
            throw new InvalidGrantException("Missing grant type");
        }
        if (!"urn:ietf:params:oauth:grant-type:saml2-bearer".equals(request.getRequestParameters().get("grant_type"))) {
            throw new InvalidGrantException("Invalid grant type");
        }
        if (new DefaultSecurityContextAccessor().isUser()) {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        throw new InvalidGrantException("User authentication not found");
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Authentication userAuth = this.validateRequest(tokenRequest);
        OAuth2Request storedOAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(storedOAuth2Request, userAuth);
    }

    protected OAuth2RequestFactory getRequestFactory() {
        return super.getRequestFactory();
    }

    protected OAuth2AccessToken getAccessToken(ClientDetails client, TokenRequest tokenRequest) {
        return super.getAccessToken(client, tokenRequest);
    }
}

