/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwt;

import org.cloudfoundry.identity.uaa.oauth.jwt.JwtAlgorithms;
import org.cloudfoundry.identity.uaa.oauth.jwt.Signer;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.RsaSigner;

public class CommonSigner
implements Signer {
    private final org.springframework.security.jwt.crypto.sign.Signer delegate;
    private final String keyId;
    private String keyURL;

    public CommonSigner(String keyId, String signingKey, String keyURL) {
        if (signingKey == null) {
            throw new IllegalArgumentException(signingKey);
        }
        this.delegate = CommonSigner.isAssymetricKey(signingKey) ? new RsaSigner(signingKey) : new MacSigner(signingKey);
        this.keyId = keyId;
        this.keyURL = keyURL;
    }

    private static boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }

    @Override
    public String keyId() {
        return this.keyId;
    }

    @Override
    public String keyURL() {
        return this.keyURL;
    }

    public byte[] sign(byte[] bytes) {
        return this.delegate.sign(bytes);
    }

    public String algorithm() {
        return JwtAlgorithms.sigAlg(this.delegate.algorithm());
    }

    public String getJavaAlgorithm() {
        return this.delegate.algorithm();
    }
}

