/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.cloudfoundry.identity.uaa.approval.ApprovalService;
import org.cloudfoundry.identity.uaa.audit.event.TokenIssuedEvent;
import org.cloudfoundry.identity.uaa.authentication.Origin;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.oauth.AuthTimeDateConverter;
import org.cloudfoundry.identity.uaa.oauth.AuthorizationAttributesParser;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfoService;
import org.cloudfoundry.identity.uaa.oauth.TokenEndpointBuilder;
import org.cloudfoundry.identity.uaa.oauth.TokenRevokedException;
import org.cloudfoundry.identity.uaa.oauth.TokenValidationService;
import org.cloudfoundry.identity.uaa.oauth.TokenValidityResolver;
import org.cloudfoundry.identity.uaa.oauth.UaaOauth2Authentication;
import org.cloudfoundry.identity.uaa.oauth.UaaTokenEnhancer;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.oauth.openid.IdTokenCreationException;
import org.cloudfoundry.identity.uaa.oauth.openid.IdTokenCreator;
import org.cloudfoundry.identity.uaa.oauth.openid.IdTokenGranter;
import org.cloudfoundry.identity.uaa.oauth.openid.UserAuthenticationData;
import org.cloudfoundry.identity.uaa.oauth.refresh.CompositeExpiringOAuth2RefreshToken;
import org.cloudfoundry.identity.uaa.oauth.refresh.RefreshTokenCreator;
import org.cloudfoundry.identity.uaa.oauth.refresh.RefreshTokenRequestData;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableToken;
import org.cloudfoundry.identity.uaa.oauth.token.RevocableTokenProvisioning;
import org.cloudfoundry.identity.uaa.oauth.token.TokenConstants;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthUserAuthority;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.user.UaaUserDatabase;
import org.cloudfoundry.identity.uaa.user.UserInfo;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.TokenValidation;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.TokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class UaaTokenServices
implements AuthorizationServerTokenServices,
ResourceServerTokenServices,
ApplicationEventPublisherAware {
    private static final String CODE = "code";
    private static final String OPENID = "openid";
    private static final List<String> NON_ADDITIONAL_ROOT_CLAIMS = Arrays.asList("jti", "sub", "authorities", "scope", "client_id", "cid", "azp", "revocable", "grant_type", "user_id", "origin", "user_name", "email", "auth_time", "rev_sig", "iat", "exp", "iss", "zid", "aud");
    private final Logger logger = LoggerFactory.getLogger(UaaTokenServices.class);
    private UaaUserDatabase userDatabase;
    private ClientServicesExtension clientDetailsService;
    private ApprovalService approvalService;
    private ApplicationEventPublisher applicationEventPublisher;
    private TokenPolicy tokenPolicy;
    private RevocableTokenProvisioning tokenProvisioning;
    private Set<String> excludedClaims;
    private UaaTokenEnhancer uaaTokenEnhancer = null;
    private IdTokenCreator idTokenCreator;
    private RefreshTokenCreator refreshTokenCreator;
    private TokenEndpointBuilder tokenEndpointBuilder;
    private TimeService timeService;
    private TokenValidityResolver accessTokenValidityResolver;
    private TokenValidationService tokenValidationService;
    private KeyInfoService keyInfoService;
    private IdTokenGranter idTokenGranter;

    public UaaTokenServices(IdTokenCreator idTokenCreator, TokenEndpointBuilder tokenEndpointBuilder, ClientServicesExtension clientDetailsService, RevocableTokenProvisioning revocableTokenProvisioning, TokenValidationService tokenValidationService, RefreshTokenCreator refreshTokenCreator, TimeService timeService, TokenValidityResolver accessTokenValidityResolver, UaaUserDatabase userDatabase, Set<String> excludedClaims, TokenPolicy globalTokenPolicy, KeyInfoService keyInfoService, IdTokenGranter idTokenGranter, ApprovalService approvalService) {
        this.idTokenCreator = idTokenCreator;
        this.tokenEndpointBuilder = tokenEndpointBuilder;
        this.clientDetailsService = clientDetailsService;
        this.tokenProvisioning = revocableTokenProvisioning;
        this.tokenValidationService = tokenValidationService;
        this.refreshTokenCreator = refreshTokenCreator;
        this.timeService = timeService;
        this.accessTokenValidityResolver = accessTokenValidityResolver;
        this.userDatabase = userDatabase;
        this.approvalService = approvalService;
        this.excludedClaims = excludedClaims;
        this.tokenPolicy = globalTokenPolicy;
        this.idTokenGranter = idTokenGranter;
        this.keyInfoService = keyInfoService;
    }

    public Set<String> getExcludedClaims() {
        return this.excludedClaims;
    }

    public void setExcludedClaims(Set<String> excludedClaims) {
        this.excludedClaims = excludedClaims;
    }

    public RevocableTokenProvisioning getTokenProvisioning() {
        return this.tokenProvisioning;
    }

    public void setTokenProvisioning(RevocableTokenProvisioning tokenProvisioning) {
        this.tokenProvisioning = tokenProvisioning;
    }

    public void setUaaTokenEnhancer(UaaTokenEnhancer uaaTokenEnhancer) {
        this.uaaTokenEnhancer = uaaTokenEnhancer;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue, TokenRequest request) throws AuthenticationException {
        if (null == refreshTokenValue) {
            throw new InvalidTokenException("Invalid refresh token (empty token)");
        }
        TokenValidation tokenValidation = this.tokenValidationService.validateToken(refreshTokenValue, false).checkJti();
        Map<String, Object> refreshTokenClaims = tokenValidation.getClaims();
        ArrayList<String> tokenScopes = this.getScopesFromRefreshToken(refreshTokenClaims);
        this.refreshTokenCreator.ensureRefreshTokenCreationNotRestricted(tokenScopes);
        String userId = (String)refreshTokenClaims.get("user_id");
        String refreshTokenId = (String)refreshTokenClaims.get("jti");
        Integer refreshTokenExpirySeconds = (Integer)refreshTokenClaims.get("exp");
        String clientId = (String)refreshTokenClaims.get("cid");
        Boolean revocableClaim = (Boolean)refreshTokenClaims.get("revocable");
        String refreshGrantType = refreshTokenClaims.get("grant_type").toString();
        String nonce = (String)refreshTokenClaims.get("nonce");
        String revocableHashSignature = (String)refreshTokenClaims.get("rev_sig");
        Map additionalAuthorizationInfo = (Map)refreshTokenClaims.get("az_attr");
        HashSet<String> audience = new HashSet<String>((ArrayList)refreshTokenClaims.get("aud"));
        Integer authTime = (Integer)refreshTokenClaims.get("auth_time");
        Set requestedScopes = request.getScope().isEmpty() ? Sets.newHashSet(tokenScopes) : request.getScope();
        Map requestParams = request.getRequestParameters();
        String requestedTokenFormat = (String)requestParams.get("token_format");
        String requestedClientId = request.getClientId();
        if (clientId == null || !clientId.equals(requestedClientId)) {
            throw new InvalidGrantException("Wrong client for this refresh token: " + clientId);
        }
        boolean isOpaque = TokenConstants.TokenFormat.OPAQUE.getStringValue().equals(requestedTokenFormat);
        boolean isRevocable = isOpaque || revocableClaim != null && revocableClaim != false;
        UaaUser user = this.userDatabase.retrieveUserById(userId);
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId);
        long refreshTokenExpireMillis = refreshTokenExpirySeconds.longValue() * 1000L;
        if (new Date(refreshTokenExpireMillis).before(this.timeService.getCurrentDate())) {
            throw new InvalidTokenException("Invalid refresh token expired at " + new Date(refreshTokenExpireMillis));
        }
        if (tokenScopes.isEmpty() || !tokenScopes.containsAll(requestedScopes)) {
            throw new InvalidScopeException("Unable to narrow the scope of the client authentication to " + requestedScopes + ".", new HashSet<String>(tokenScopes));
        }
        this.approvalService.ensureRequiredApprovals(userId, requestedScopes, refreshGrantType, client);
        this.throwIfInvalidRevocationHashSignature(revocableHashSignature, user, (ClientDetails)client);
        HashMap<String, Object> additionalRootClaims = new HashMap<String, Object>();
        if (this.uaaTokenEnhancer != null) {
            refreshTokenClaims.entrySet().stream().filter(entry -> !NON_ADDITIONAL_ROOT_CLAIMS.contains(entry.getKey())).forEach(entry -> additionalRootClaims.put((String)entry.getKey(), entry.getValue()));
            refreshTokenClaims.remove("granted_scopes");
        }
        UserAuthenticationData authenticationData = new UserAuthenticationData(AuthTimeDateConverter.authTimeToDate(authTime), (Set<String>)this.authenticationMethodsAsSet(refreshTokenClaims), this.getAcrAsSet(refreshTokenClaims), requestedScopes, (Set<String>)this.rolesAsSet(userId), (Map<String, List<String>>)this.getUserAttributes(userId), nonce, refreshGrantType, this.generateUniqueTokenId());
        String accessTokenId = this.generateUniqueTokenId();
        refreshTokenValue = tokenValidation.getJwt().getEncoded();
        CompositeToken compositeToken = this.createCompositeToken(accessTokenId, user.getId(), user, AuthTimeDateConverter.authTimeToDate(authTime), this.getClientPermissions((ClientDetails)client), clientId, audience, refreshTokenValue, additionalAuthorizationInfo, additionalRootClaims, revocableHashSignature, isRevocable, authenticationData);
        CompositeExpiringOAuth2RefreshToken expiringRefreshToken = new CompositeExpiringOAuth2RefreshToken(refreshTokenValue, new Date(refreshTokenExpireMillis), refreshTokenId);
        return this.persistRevocableToken(accessTokenId, compositeToken, expiringRefreshToken, clientId, user.getId(), isOpaque, isRevocable);
    }

    private void throwIfInvalidRevocationHashSignature(String revocableHashSignature, UaaUser user, ClientDetails client) {
        if (StringUtils.hasText((String)revocableHashSignature)) {
            String newRevocableHashSignature;
            String clientSecretForHash = client.getClientSecret();
            if (clientSecretForHash != null && clientSecretForHash.split(" ").length > 1) {
                clientSecretForHash = clientSecretForHash.split(" ")[1];
            }
            if (!revocableHashSignature.equals(newRevocableHashSignature = UaaTokenUtils.getRevocableTokenSignature(client, clientSecretForHash, user))) {
                throw new TokenRevokedException("Invalid refresh token: revocable signature mismatch");
            }
        }
    }

    private Set<String> getAcrAsSet(Map<String, Object> refreshTokenClaims) {
        Map acrFromRefreshToken = (Map)refreshTokenClaims.get("acr");
        if (acrFromRefreshToken == null) {
            return null;
        }
        return new HashSet<String>((Collection)acrFromRefreshToken.get("values"));
    }

    private MultiValueMap<String, String> getUserAttributes(String userId) {
        UserInfo userInfo = this.userDatabase.getUserInfo(userId);
        if (userInfo != null) {
            return userInfo.getUserAttributes();
        }
        return new LinkedMultiValueMap();
    }

    private HashSet<String> rolesAsSet(String userId) {
        UserInfo userInfo = this.userDatabase.getUserInfo(userId);
        if (userInfo != null) {
            ArrayList roles = (ArrayList)userInfo.getRoles();
            return roles == null ? Sets.newHashSet() : Sets.newHashSet((Iterable)roles);
        }
        return Sets.newHashSet();
    }

    private HashSet<String> authenticationMethodsAsSet(Map<String, Object> refreshTokenClaims) {
        ArrayList authenticationMethods = (ArrayList)refreshTokenClaims.get("amr");
        return authenticationMethods == null ? Sets.newHashSet() : Sets.newHashSet((Iterable)authenticationMethods);
    }

    private CompositeToken createCompositeToken(String tokenId, String userId, UaaUser user, Date userAuthenticationTime, Collection<GrantedAuthority> clientScopes, String clientId, Set<String> resourceIds, String refreshToken, Map<String, String> additionalAuthorizationAttributes, Map<String, Object> additionalRootClaims, String revocableHashSignature, boolean isRevocable, UserAuthenticationData userAuthenticationData) throws AuthenticationException {
        String content;
        String nonce;
        CompositeToken compositeToken = new CompositeToken(tokenId);
        compositeToken.setExpiration(this.accessTokenValidityResolver.resolve(clientId));
        compositeToken.setRefreshToken((OAuth2RefreshToken)(refreshToken == null ? null : new DefaultOAuth2RefreshToken(refreshToken)));
        Set<String> requestedScopes = userAuthenticationData.scopes;
        String grantType = userAuthenticationData.grantType;
        if (null == requestedScopes || requestedScopes.size() == 0) {
            this.logger.debug("No scopes were granted");
            throw new InvalidTokenException("No scopes were granted");
        }
        compositeToken.setScope(requestedScopes);
        ConcurrentHashMap<String, Object> info = new ConcurrentHashMap<String, Object>();
        info.put("jti", compositeToken.getValue());
        if (null != additionalAuthorizationAttributes) {
            info.put("az_attr", additionalAuthorizationAttributes);
        }
        if ((nonce = userAuthenticationData.nonce) != null) {
            info.put("nonce", nonce);
        }
        compositeToken.setAdditionalInformation(info);
        Map<String, ?> jwtAccessToken = this.createJWTAccessToken((OAuth2AccessToken)compositeToken, userId, user, userAuthenticationTime, clientScopes, requestedScopes, clientId, resourceIds, grantType, revocableHashSignature, isRevocable, additionalRootClaims);
        try {
            content = JsonUtils.writeValueAsString(jwtAccessToken);
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new IllegalStateException("Cannot convert access token to JSON", e);
        }
        String token = JwtHelper.encode(content, this.getActiveKeyInfo()).getEncoded();
        compositeToken.setValue(token);
        BaseClientDetails clientDetails = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId);
        if (this.idTokenGranter.shouldSendIdToken(userId, clientDetails, requestedScopes, grantType)) {
            String idTokenContent;
            try {
                idTokenContent = JsonUtils.writeValueAsString((Object)this.idTokenCreator.create(clientId, userId, userAuthenticationData));
            }
            catch (RuntimeException | IdTokenCreationException e) {
                throw new IllegalStateException("Cannot convert id token to JSON");
            }
            String encodedIdTokenContent = JwtHelper.encode(idTokenContent, this.keyInfoService.getActiveKey()).getEncoded();
            compositeToken.setIdTokenValue(encodedIdTokenContent);
        }
        this.publish(new TokenIssuedEvent((OAuth2AccessToken)compositeToken, SecurityContextHolder.getContext().getAuthentication()));
        return compositeToken;
    }

    private KeyInfo getActiveKeyInfo() {
        return Optional.ofNullable(this.keyInfoService.getActiveKey()).orElseThrow(() -> new InternalAuthenticationServiceException("Unable to sign token, misconfigured JWT signing keys"));
    }

    private Map<String, ?> createJWTAccessToken(OAuth2AccessToken token, String userId, UaaUser user, Date userAuthenticationTime, Collection<GrantedAuthority> clientScopes, Set<String> requestedScopes, String clientId, Set<String> resourceIds, String grantType, String revocableHashSignature, boolean isRevocable, Map<String, Object> additionalRootClaims) {
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put("jti", token.getAdditionalInformation().get("jti"));
        claims.putAll(token.getAdditionalInformation());
        if (additionalRootClaims != null) {
            claims.putAll(additionalRootClaims);
        }
        claims.put("sub", clientId);
        if ("client_credentials".equals(grantType)) {
            claims.put("authorities", AuthorityUtils.authorityListToSet(clientScopes));
        }
        claims.put("scope", requestedScopes);
        claims.put("client_id", clientId);
        claims.put("cid", clientId);
        claims.put("azp", clientId);
        if (isRevocable) {
            claims.put("revocable", true);
        }
        if (null != grantType) {
            claims.put("grant_type", grantType);
        }
        if (user != null && userId != null) {
            String username;
            claims.put("user_id", userId);
            String origin = user.getOrigin();
            if (StringUtils.hasLength((String)origin)) {
                claims.put("origin", origin);
            }
            claims.put("user_name", (username = user.getUsername()) == null ? userId : username);
            String userEmail = user.getEmail();
            if (userEmail != null) {
                claims.put("email", userEmail);
            }
            if (userAuthenticationTime != null) {
                claims.put("auth_time", userAuthenticationTime.getTime() / 1000L);
            }
            claims.put("sub", userId);
        }
        if (StringUtils.hasText((String)revocableHashSignature)) {
            claims.put("rev_sig", revocableHashSignature);
        }
        claims.put("iat", this.timeService.getCurrentTimeMillis() / 1000L);
        claims.put("exp", token.getExpiration().getTime() / 1000L);
        if (this.tokenEndpointBuilder.getTokenEndpoint() != null) {
            claims.put("iss", this.tokenEndpointBuilder.getTokenEndpoint());
            claims.put("zid", IdentityZoneHolder.get().getId());
        }
        claims.put("aud", resourceIds);
        for (String excludedClaim : this.getExcludedClaims()) {
            claims.remove(excludedClaim);
        }
        return claims;
    }

    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) throws AuthenticationException {
        String userId = null;
        Date userAuthenticationTime = null;
        UaaUser user = null;
        Set<String> authenticationMethods = null;
        Set<String> authNContextClassRef = null;
        OAuth2Request oAuth2Request = authentication.getOAuth2Request();
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(oAuth2Request.getClientId(), IdentityZoneHolder.get().getId());
        Collection<GrantedAuthority> clientScopes = null;
        if (authentication.isClientOnly()) {
            clientScopes = client.getAuthorities();
        } else {
            clientScopes = this.getClientPermissions((ClientDetails)client);
            userId = this.getUserId(authentication);
            user = this.userDatabase.retrieveUserById(userId);
            if (authentication.getUserAuthentication() instanceof UaaAuthentication) {
                userAuthenticationTime = new Date(((UaaAuthentication)authentication.getUserAuthentication()).getAuthenticatedTime());
                authenticationMethods = ((UaaAuthentication)authentication.getUserAuthentication()).getAuthenticationMethods();
                authNContextClassRef = ((UaaAuthentication)authentication.getUserAuthentication()).getAuthContextClassRef();
            }
            this.validateRequiredUserGroups(user, (ClientDetails)client);
        }
        String clientSecretForHash = client.getClientSecret();
        if (clientSecretForHash != null && clientSecretForHash.split(" ").length > 1) {
            clientSecretForHash = clientSecretForHash.split(" ")[1];
        }
        String revocableHashSignature = UaaTokenUtils.getRevocableTokenSignature((ClientDetails)client, clientSecretForHash, user);
        String tokenId = this.generateUniqueTokenId();
        boolean isOpaque = this.isOpaqueTokenRequired(authentication);
        boolean isAccessTokenRevocable = isOpaque || this.getActiveTokenPolicy().isJwtRevocable();
        boolean isRefreshTokenRevocable = isAccessTokenRevocable || TokenConstants.TokenFormat.OPAQUE.getStringValue().equals(this.getActiveTokenPolicy().getRefreshTokenFormat());
        HashMap<String, Object> additionalRootClaims = null;
        if (this.uaaTokenEnhancer != null) {
            additionalRootClaims = new HashMap<String, Object>(this.uaaTokenEnhancer.enhance(Collections.emptyMap(), authentication));
        }
        CompositeExpiringOAuth2RefreshToken refreshToken = null;
        if (client.getAuthorizedGrantTypes().contains("refresh_token")) {
            RefreshTokenRequestData refreshTokenRequestData = new RefreshTokenRequestData(oAuth2Request.getGrantType(), oAuth2Request.getScope(), authenticationMethods, (String)oAuth2Request.getRequestParameters().get("authorities"), oAuth2Request.getResourceIds(), oAuth2Request.getClientId(), isRefreshTokenRevocable, userAuthenticationTime, authNContextClassRef, additionalRootClaims);
            refreshToken = this.refreshTokenCreator.createRefreshToken(user, refreshTokenRequestData, revocableHashSignature);
        }
        String clientId = oAuth2Request.getClientId();
        Set userScopes = oAuth2Request.getScope();
        Map requestParameters = oAuth2Request.getRequestParameters();
        String grantType = (String)requestParameters.get("grant_type");
        LinkedHashSet<String> modifiableUserScopes = new LinkedHashSet<String>(userScopes);
        Set<Object> externalGroupsForIdToken = Sets.newHashSet();
        MultiValueMap<String, String> userAttributesForIdToken = Maps.newHashMap();
        if (authentication.getUserAuthentication() instanceof UaaAuthentication) {
            externalGroupsForIdToken = ((UaaAuthentication)authentication.getUserAuthentication()).getExternalGroups();
            userAttributesForIdToken = ((UaaAuthentication)authentication.getUserAuthentication()).getUserAttributes();
        }
        String nonce = (String)requestParameters.get("nonce");
        Map<String, String> additionalAuthorizationAttributes = new AuthorizationAttributesParser().getAdditionalAuthorizationAttributes((String)requestParameters.get("authorities"));
        UserAuthenticationData authenticationData = new UserAuthenticationData(userAuthenticationTime, authenticationMethods, authNContextClassRef, (Set<String>)modifiableUserScopes, externalGroupsForIdToken, (Map<String, List<String>>)userAttributesForIdToken, nonce, grantType, tokenId);
        String refreshTokenValue = refreshToken != null ? refreshToken.getValue() : null;
        CompositeToken accessToken = this.createCompositeToken(tokenId, userId, user, userAuthenticationTime, clientScopes, clientId, oAuth2Request.getResourceIds(), refreshTokenValue, additionalAuthorizationAttributes, additionalRootClaims, revocableHashSignature, isAccessTokenRevocable, authenticationData);
        return this.persistRevocableToken(tokenId, accessToken, refreshToken, clientId, userId, isOpaque, isAccessTokenRevocable);
    }

    private TokenPolicy getActiveTokenPolicy() {
        return IdentityZoneHolder.get().getConfig().getTokenPolicy();
    }

    private Collection<GrantedAuthority> getClientPermissions(ClientDetails client) {
        ArrayList<GrantedAuthority> clientScopes = new ArrayList<GrantedAuthority>();
        for (String scope : client.getScope()) {
            clientScopes.add(new XOAuthUserAuthority(scope));
        }
        return clientScopes;
    }

    private void validateRequiredUserGroups(UaaUser user, ClientDetails client) {
        Collection requiredUserGroups = Optional.ofNullable((Collection)client.getAdditionalInformation().get("required_user_groups")).orElse(Collections.emptySet());
        if (!UaaTokenUtils.hasRequiredUserAuthorities(requiredUserGroups, user.getAuthorities())) {
            throw new InvalidTokenException("User does not meet the client's required group criteria.");
        }
    }

    CompositeToken persistRevocableToken(String tokenId, CompositeToken token, CompositeExpiringOAuth2RefreshToken refreshToken, String clientId, String userId, boolean isOpaque, boolean isRevocable) {
        String scope = token.getScope().toString();
        long now = this.timeService.getCurrentTimeMillis();
        if (isRevocable) {
            RevocableToken revocableAccessToken = new RevocableToken().setTokenId(tokenId).setClientId(clientId).setExpiresAt(token.getExpiration().getTime()).setIssuedAt(now).setFormat(isOpaque ? TokenConstants.TokenFormat.OPAQUE.getStringValue() : TokenConstants.TokenFormat.JWT.getStringValue()).setResponseType(RevocableToken.TokenType.ACCESS_TOKEN).setZoneId(IdentityZoneHolder.get().getId()).setUserId(userId).setScope(scope).setValue(token.getValue());
            try {
                this.tokenProvisioning.create(revocableAccessToken, IdentityZoneHolder.get().getId());
            }
            catch (DuplicateKeyException updateInstead) {
                this.tokenProvisioning.update(tokenId, revocableAccessToken, IdentityZoneHolder.get().getId());
            }
        }
        boolean isRefreshTokenOpaque = isOpaque || TokenConstants.TokenFormat.OPAQUE.getStringValue().equals(this.getActiveTokenPolicy().getRefreshTokenFormat());
        boolean refreshTokenRevocable = isRefreshTokenOpaque || this.getActiveTokenPolicy().isJwtRevocable();
        boolean refreshTokenUnique = this.getActiveTokenPolicy().isRefreshTokenUnique();
        if (refreshToken != null && refreshTokenRevocable) {
            RevocableToken revocableRefreshToken = new RevocableToken().setTokenId(refreshToken.getJti()).setClientId(clientId).setExpiresAt(refreshToken.getExpiration().getTime()).setIssuedAt(now).setFormat(isRefreshTokenOpaque ? TokenConstants.TokenFormat.OPAQUE.getStringValue() : TokenConstants.TokenFormat.JWT.getStringValue()).setResponseType(RevocableToken.TokenType.REFRESH_TOKEN).setZoneId(IdentityZoneHolder.get().getId()).setUserId(userId).setScope(scope).setValue(refreshToken.getValue());
            try {
                if (refreshTokenUnique) {
                    this.tokenProvisioning.deleteRefreshTokensForClientAndUserId(clientId, userId, IdentityZoneHolder.get().getId());
                }
                this.tokenProvisioning.create(revocableRefreshToken, IdentityZoneHolder.get().getId());
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        }
        CompositeToken result = new CompositeToken(isOpaque ? tokenId : token.getValue());
        result.setIdTokenValue(token.getIdTokenValue());
        result.setExpiration(token.getExpiration());
        result.setAdditionalInformation(token.getAdditionalInformation());
        result.setScope(token.getScope());
        result.setTokenType(token.getTokenType());
        result.setRefreshToken(this.buildRefreshTokenResponse(refreshToken, isRefreshTokenOpaque));
        return result;
    }

    private OAuth2RefreshToken buildRefreshTokenResponse(CompositeExpiringOAuth2RefreshToken refreshToken, boolean isRefreshTokenOpaque) {
        if (refreshToken == null) {
            return null;
        }
        if (isRefreshTokenOpaque) {
            return new DefaultOAuth2RefreshToken(refreshToken.getJti());
        }
        return new DefaultOAuth2RefreshToken(refreshToken.getValue());
    }

    boolean isOpaqueTokenRequired(OAuth2Authentication authentication) {
        Map parameters = authentication.getOAuth2Request().getRequestParameters();
        return TokenConstants.TokenFormat.OPAQUE.getStringValue().equals(parameters.get("token_format")) || "user_token".equals(parameters.get("grant_type"));
    }

    private String getUserId(OAuth2Authentication authentication) {
        return Origin.getUserId(authentication.getUserAuthentication());
    }

    private String generateUniqueTokenId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public void setUserDatabase(UaaUserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException {
        if (StringUtils.isEmpty((Object)accessToken)) {
            throw new InvalidTokenException("Invalid access token value, must be at least 30 characters");
        }
        TokenValidation tokenValidation = this.tokenValidationService.validateToken(accessToken, true).checkJti();
        Map<String, Object> claims = tokenValidation.getClaims();
        accessToken = tokenValidation.getJwt().getEncoded();
        Long expiration = Long.valueOf(claims.get("exp").toString());
        if (new Date(expiration * 1000L).before(this.timeService.getCurrentDate())) {
            throw new InvalidTokenException("Invalid access token: expired at " + new Date(expiration * 1000L));
        }
        ArrayList scopes = (ArrayList)claims.get("scope");
        AuthorizationRequest authorizationRequest = new AuthorizationRequest((String)claims.get("client_id"), (Collection)scopes);
        ArrayList rids = (ArrayList)claims.get("aud");
        Set resourceIds = Collections.unmodifiableSet(rids == null ? new HashSet() : new HashSet(rids));
        authorizationRequest.setResourceIds(resourceIds);
        authorizationRequest.setApproved(true);
        List defaultUserAuthorities = IdentityZoneHolder.get().getConfig().getUserConfig().getDefaultGroups();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString((Collection)defaultUserAuthorities));
        if (claims.containsKey("authorities")) {
            Object authoritiesFromClaims = claims.get("authorities");
            if (authoritiesFromClaims instanceof String) {
                authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)authoritiesFromClaims));
            }
            if (authoritiesFromClaims instanceof Collection) {
                authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString((Collection)((Collection)authoritiesFromClaims)));
            }
        }
        UaaAuthentication userAuthentication = null;
        if (claims.containsKey("user_id")) {
            UaaUser user = this.userDatabase.retrieveUserById((String)claims.get("user_id"));
            UaaPrincipal principal = new UaaPrincipal(user);
            userAuthentication = new UaaAuthentication(principal, UaaAuthority.USER_AUTHORITIES, null);
        } else {
            authorizationRequest.setAuthorities((Collection)authorities);
        }
        UaaOauth2Authentication authentication = new UaaOauth2Authentication(accessToken, IdentityZoneHolder.get().getId(), authorizationRequest.createOAuth2Request(), userAuthentication);
        authentication.setAuthenticated(true);
        return authentication;
    }

    private ArrayList<String> getScopesFromRefreshToken(Map<String, Object> claims) {
        if (claims.containsKey("granted_scopes")) {
            return (ArrayList)claims.get("granted_scopes");
        }
        return (ArrayList)claims.get("scope");
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        TokenValidation tokenValidation = this.tokenValidationService.validateToken(accessToken, true).checkJti();
        Map<String, Object> claims = tokenValidation.getClaims();
        accessToken = tokenValidation.getJwt().getEncoded();
        CompositeToken token = new CompositeToken(accessToken);
        token.setTokenType("Bearer");
        token.setExpiration(new Date(Long.valueOf(claims.get("exp").toString()) * 1000L));
        ArrayList scopes = (ArrayList)claims.get("scope");
        if (null != scopes && scopes.size() > 0) {
            token.setScope(new HashSet(scopes));
        }
        String clientId = (String)claims.get("cid");
        String userId = (String)claims.get("user_id");
        BaseClientDetails client = (BaseClientDetails)this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        if (null != userId) {
            ArrayList tokenScopes = (ArrayList)claims.get("scope");
            this.approvalService.ensureRequiredApprovals(userId, tokenScopes, (String)claims.get("grant_type"), client);
        }
        return token;
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        return null;
    }

    public void setClientDetailsService(ClientServicesExtension clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    private void publish(TokenIssuedEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy) {
        this.tokenPolicy = tokenPolicy;
    }

    public TokenPolicy getTokenPolicy() {
        return this.tokenPolicy;
    }

    public void setTokenEndpointBuilder(TokenEndpointBuilder tokenEndpointBuilder) {
        this.tokenEndpointBuilder = tokenEndpointBuilder;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public void setKeyInfoService(KeyInfoService keyInfoService) {
        this.keyInfoService = keyInfoService;
    }
}

