/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.exceptions.RedirectMismatchException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.util.AntPathMatcher;

public class AntPathRedirectResolver
extends DefaultRedirectResolver {
    private static final Logger logger = LoggerFactory.getLogger(AntPathRedirectResolver.class);

    protected boolean redirectMatches(String requestedRedirect, String clientRedirect) {
        try {
            URI requestedRedirectURI = URI.create(requestedRedirect);
            ClientRedirectUriPattern clientRedirectUri = new ClientRedirectUriPattern(clientRedirect);
            if (!clientRedirectUri.isValidRedirect()) {
                logger.error(String.format("Invalid redirect uri: %s", clientRedirect));
                return false;
            }
            if (clientRedirectUri.isWildcard(clientRedirect) && clientRedirectUri.isSafeRedirect(requestedRedirectURI) && clientRedirectUri.match(requestedRedirectURI)) {
                return true;
            }
            return super.redirectMatches(requestedRedirect, clientRedirect);
        }
        catch (IllegalArgumentException e) {
            logger.error(String.format("Could not validate whether requestedRedirect (%s) matches clientRedirectUri (%s)", requestedRedirect, clientRedirect), (Throwable)e);
            return false;
        }
    }

    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        Set registeredRedirectUris = Optional.ofNullable(client.getRegisteredRedirectUri()).orElse(Collections.emptySet());
        if (registeredRedirectUris.isEmpty()) {
            throw new RedirectMismatchException("Client registration is missing redirect_uri");
        }
        List invalidUrls = registeredRedirectUris.stream().filter(url -> !UaaUrlUtils.isValidRegisteredRedirectUrl(url)).collect(Collectors.toList());
        if (!invalidUrls.isEmpty()) {
            throw new RedirectMismatchException("Client registration contains invalid redirect_uri: " + invalidUrls);
        }
        return super.resolveRedirect(requestedRedirect, client);
    }

    private static class ClientRedirectUriPattern {
        private static final Pattern URI_EXTRACTOR = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
        private static final int URI_EXTRACTOR_AUTHORITY_GROUP = 4;
        private Matcher redirectMatcher;
        private boolean isValidRedirect = true;
        private AntPathMatcher matcher;
        private String redirectUri;

        ClientRedirectUriPattern(String redirectUri) {
            if (redirectUri == null) {
                throw new IllegalArgumentException("Client Redirect URI was null");
            }
            this.redirectUri = redirectUri;
            this.matcher = new AntPathMatcher();
            this.redirectMatcher = URI_EXTRACTOR.matcher(redirectUri);
            if (!this.redirectMatcher.matches()) {
                this.isValidRedirect = false;
            }
        }

        boolean isSafeRedirect(URI requestedRedirect) {
            String[] configuredRedirectHost = ClientRedirectUriPattern.splitAndReverseHost(this.getHost());
            String[] requestedRedirectHost = ClientRedirectUriPattern.splitAndReverseHost(requestedRedirect.getHost());
            if (requestedRedirectHost.length < configuredRedirectHost.length) {
                return false;
            }
            boolean isSafe = true;
            for (int i = 0; i < configuredRedirectHost.length && !this.isWildcard(configuredRedirectHost[i]); ++i) {
                isSafe = isSafe && configuredRedirectHost[i].equals(requestedRedirectHost[i]);
            }
            return isSafe;
        }

        boolean isValidRedirect() {
            return this.isValidRedirect;
        }

        boolean match(URI requestedRedirect) {
            return this.matcher.match(this.redirectUri, requestedRedirect.toString());
        }

        private boolean isWildcard(String configuredRedirectPattern) {
            return configuredRedirectPattern.contains("*");
        }

        private String getHost() {
            String authority = this.redirectMatcher.group(4);
            return this.stripPort(this.stripAuthority(authority));
        }

        private String stripAuthority(String authority) {
            if (authority.contains("@")) {
                return authority.split("@")[1];
            }
            return authority;
        }

        private String stripPort(String hostAndPort) {
            if (hostAndPort.contains(":")) {
                return hostAndPort.split(":")[0];
            }
            return hostAndPort;
        }

        private static String[] splitAndReverseHost(String host) {
            Object[] parts = host.split("\\.");
            ArrayUtils.reverse((Object[])parts);
            return parts;
        }
    }
}

