/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class NotificationsService
implements MessageService {
    private final RestTemplate notificationsTemplate;
    private final String notificationsUrl;
    private final Map<MessageType, HashMap<String, Object>> notifications;
    private final boolean sendInDefaultZone;
    private Boolean isNotificationsRegistered = false;

    public Boolean getIsNotificationsRegistered() {
        return this.isNotificationsRegistered;
    }

    public NotificationsService(RestTemplate notificationsTemplate, String notificationsUrl, Map<MessageType, HashMap<String, Object>> notifications, boolean sendInDefaultZone) {
        this.notificationsTemplate = notificationsTemplate;
        this.notificationsUrl = notificationsUrl;
        this.notifications = notifications;
        this.sendInDefaultZone = sendInDefaultZone;
    }

    public boolean isSendInDefaultZone() {
        return this.sendInDefaultZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String email, MessageType messageType, String subject, String htmlContent) {
        IdentityZone current = IdentityZoneHolder.get();
        try {
            if (this.isSendInDefaultZone()) {
                IdentityZoneHolder.set(IdentityZone.getUaa());
            }
            this.internalSendMessage(email, messageType, subject, htmlContent);
        }
        finally {
            IdentityZoneHolder.set(current);
        }
    }

    protected void internalSendMessage(String email, MessageType messageType, String subject, String htmlContent) {
        if (!this.getIsNotificationsRegistered().booleanValue()) {
            this.registerNotifications();
        }
        HashMap<String, String> request = new HashMap<String, String>();
        String kindId = (String)this.notifications.get((Object)messageType).get("id");
        request.put("kind_id", kindId);
        request.put("to", email);
        request.put("subject", subject);
        request.put("html", htmlContent);
        HttpEntity requestEntity = new HttpEntity(request);
        this.notificationsTemplate.exchange(this.notificationsUrl + "/emails", HttpMethod.POST, requestEntity, Void.class, new Object[0]);
    }

    private void registerNotifications() {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("source_description", "CF_Identity");
        request.put("kinds", this.notifications.values());
        this.notificationsTemplate.put(this.notificationsUrl + "/registration", request, new Object[0]);
        this.isNotificationsRegistered = true;
    }
}

