/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.authentication.PasswordChangeRequiredException;
import org.cloudfoundry.identity.uaa.login.CurrentUserCookieFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class UaaAuthenticationFailureHandler
implements AuthenticationFailureHandler,
LogoutHandler {
    private ExceptionMappingAuthenticationFailureHandler delegate;
    private CurrentUserCookieFactory currentUserCookieFactory;

    public UaaAuthenticationFailureHandler(ExceptionMappingAuthenticationFailureHandler delegate, CurrentUserCookieFactory currentUserCookieFactory) {
        this.delegate = delegate;
        this.currentUserCookieFactory = currentUserCookieFactory;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.addCookie(response);
        if (exception != null && exception instanceof PasswordChangeRequiredException) {
            request.getSession().setAttribute("FORCE_PASSWORD_EXPIRED_USER", (Object)((PasswordChangeRequiredException)exception).getAuthentication());
        }
        if (this.delegate != null) {
            this.delegate.onAuthenticationFailure(request, response, exception);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCookie(response);
    }

    private void addCookie(HttpServletResponse response) {
        Cookie clearCurrentUserCookie = this.currentUserCookieFactory.getNullCookie();
        response.addCookie(clearCurrentUserCookie);
    }
}

