/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.login;

import java.awt.Color;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaLoginHint;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeType;
import org.cloudfoundry.identity.uaa.login.AutologinRequest;
import org.cloudfoundry.identity.uaa.login.AutologinResponse;
import org.cloudfoundry.identity.uaa.login.PasscodeInformation;
import org.cloudfoundry.identity.uaa.login.Prompt;
import org.cloudfoundry.identity.uaa.login.SavedAccountOption;
import org.cloudfoundry.identity.uaa.mfa.MfaChecker;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.AbstractXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.LoginSamlAuthenticationToken;
import org.cloudfoundry.identity.uaa.provider.saml.SamlIdentityProviderConfigurator;
import org.cloudfoundry.identity.uaa.provider.saml.SamlRedirectUtils;
import org.cloudfoundry.identity.uaa.util.ColorHash;
import org.cloudfoundry.identity.uaa.util.DomainFilter;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.MapCollector;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.util.UaaUrlUtils;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneConfiguration;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.cloudfoundry.identity.uaa.zone.Links;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class LoginInfoEndpoint {
    public static final String MFA_CODE = "mfaCode";
    private static Log logger = LogFactory.getLog(LoginInfoEndpoint.class);
    public static final String NotANumber = "NaN";
    public static final String CREATE_ACCOUNT_LINK = "createAccountLink";
    public static final String FORGOT_PASSWORD_LINK = "forgotPasswordLink";
    public static final String LINK_CREATE_ACCOUNT_SHOW = "linkCreateAccountShow";
    public static final String FIELD_USERNAME_SHOW = "fieldUsernameShow";
    public static final List<String> UI_ONLY_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("createAccountLink", "forgotPasswordLink", "linkCreateAccountShow", "fieldUsernameShow"));
    public static final String PASSCODE = "passcode";
    public static final String SHOW_LOGIN_LINKS = "showLoginLinks";
    public static final String LINKS = "links";
    public static final String ZONE_NAME = "zone_name";
    public static final String ENTITY_ID = "entityID";
    public static final String IDP_DEFINITIONS = "idpDefinitions";
    public static final String OAUTH_LINKS = "oauthLinks";
    private Properties gitProperties = new Properties();
    private Properties buildProperties = new Properties();
    private String baseUrl;
    private String externalLoginUrl;
    private String samlSPBaseUrl;
    private String uaaHost;
    private SamlIdentityProviderConfigurator idpDefinitions;
    private long codeExpirationMillis = 300000L;
    private AuthenticationManager authenticationManager;
    private ExpiringCodeStore expiringCodeStore;
    private ClientServicesExtension clientDetailsService;
    private IdentityProviderProvisioning providerProvisioning;
    private MapCollector<IdentityProvider, String, AbstractXOAuthIdentityProviderDefinition> idpsMapCollector = new MapCollector<IdentityProvider, String, AbstractXOAuthIdentityProviderDefinition>(idp -> idp.getOriginKey(), idp -> (AbstractXOAuthIdentityProviderDefinition)idp.getConfig());
    private XOAuthProviderConfigurator xoAuthProviderConfigurator;
    private Links globalLinks = new Links().setSelfService(new Links.SelfService().setPasswd(null).setSignup(null));
    private MfaChecker mfaChecker;
    private String entityID = "";
    private static final Pattern urlPattern = Pattern.compile("((https?|ftp|gopher|telnet|file):((//)|(\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)", 2);

    public void setGlobalLinks(Links globalLinks) {
        this.globalLinks = globalLinks;
    }

    public LoginInfoEndpoint setXoAuthProviderConfigurator(XOAuthProviderConfigurator xoAuthProviderConfigurator) {
        this.xoAuthProviderConfigurator = xoAuthProviderConfigurator;
        return this;
    }

    public void setExpiringCodeStore(ExpiringCodeStore expiringCodeStore) {
        this.expiringCodeStore = expiringCodeStore;
    }

    public long getCodeExpirationMillis() {
        return this.codeExpirationMillis;
    }

    public void setCodeExpirationMillis(long codeExpirationMillis) {
        this.codeExpirationMillis = codeExpirationMillis;
    }

    public void setIdpDefinitions(SamlIdentityProviderConfigurator idpDefinitions) {
        this.idpDefinitions = idpDefinitions;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public void setMfaChecker(MfaChecker mfaChecker) {
        this.mfaChecker = mfaChecker;
    }

    public LoginInfoEndpoint() {
        try {
            this.gitProperties = PropertiesLoaderUtils.loadAllProperties((String)"git.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.buildProperties = PropertiesLoaderUtils.loadAllProperties((String)"build.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @RequestMapping(value={"/login"}, headers={"Accept=application/json"})
    public String infoForLoginJson(Model model, Principal principal, HttpServletRequest request) {
        return this.login(model, principal, Collections.emptyList(), true, request);
    }

    @RequestMapping(value={"/info"}, headers={"Accept=application/json"})
    public String infoForJson(Model model, Principal principal, HttpServletRequest request) {
        return this.login(model, principal, Collections.emptyList(), true, request);
    }

    @RequestMapping(value={"/login"}, headers={"Accept=text/html, */*"})
    public String loginForHtml(Model model, Principal principal, HttpServletRequest request, @RequestHeader(value="Accept", required=false) List<MediaType> headers) throws HttpMediaTypeNotAcceptableException {
        boolean match;
        boolean bl = match = headers == null || headers.stream().anyMatch(mediaType -> mediaType.isCompatibleWith(MediaType.TEXT_HTML));
        if (!match) {
            throw new HttpMediaTypeNotAcceptableException(request.getHeader("Accept"));
        }
        Cookie[] cookies = request.getCookies();
        List<SavedAccountOptionModel> savedAccounts = LoginInfoEndpoint.getSavedAccounts(cookies, SavedAccountOptionModel.class);
        savedAccounts.forEach(account -> {
            Color color = ColorHash.getColor(account.getUserId());
            account.assignColors(color);
        });
        model.addAttribute("savedAccounts", savedAccounts);
        return this.login(model, principal, Arrays.asList(PASSCODE, MFA_CODE), false, request);
    }

    private static <T extends SavedAccountOption> List<T> getSavedAccounts(Cookie[] cookies, Class<T> clazz) {
        return Arrays.asList((Object[])Optional.ofNullable(cookies).orElse(new Cookie[0])).stream().filter(c -> c.getName().startsWith("Saved-Account")).map(c -> {
            try {
                return (SavedAccountOption)JsonUtils.readValue((String)LoginInfoEndpoint.decodeCookieValue(c.getValue()), (Class)clazz);
            }
            catch (JsonUtils.JsonUtilException e) {
                return null;
            }
        }).filter(c -> c != null).collect(Collectors.toList());
    }

    private static String decodeCookieValue(String inValue) {
        String out = null;
        try {
            out = URLDecoder.decode(inValue, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            logger.debug((Object)("URLDecoder.decode failed for " + inValue), (Throwable)e);
            return "";
        }
        return out;
    }

    @RequestMapping(value={"/invalid_request"})
    public String invalidRequest(HttpServletRequest request) {
        return "invalid_request";
    }

    protected String getZonifiedEntityId() {
        return SamlRedirectUtils.getZonifiedEntityId(this.entityID);
    }

    private String login(Model model, Principal principal, List<String> excludedPrompts, boolean jsonResponse, HttpServletRequest request) {
        String externalRedirect;
        String defaultIdentityProviderName;
        boolean discoveryPerformed;
        if (principal instanceof UaaAuthentication && ((UaaAuthentication)((Object)principal)).isAuthenticated()) {
            return "redirect:/home";
        }
        HttpSession session = request != null ? request.getSession(false) : null;
        List allowedIdentityProviderKeys = null;
        String clientName = null;
        Map<String, Object> clientInfo = this.getClientInfo(session);
        if (clientInfo != null) {
            allowedIdentityProviderKeys = (List)clientInfo.get("allowedproviders");
            clientName = (String)clientInfo.get("name");
        }
        final Map<String, SamlIdentityProviderDefinition> samlIdentityProviders = this.getSamlIdentityProviderDefinitions(allowedIdentityProviderKeys);
        final Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviders = this.getOauthIdentityProviderDefinitions(allowedIdentityProviderKeys);
        HashMap<String, AbstractIdentityProviderDefinition> allIdentityProviders = new HashMap<String, AbstractIdentityProviderDefinition>(){
            {
                this.putAll(samlIdentityProviders);
                this.putAll(oauthIdentityProviders);
            }
        };
        boolean fieldUsernameShow = true;
        boolean returnLoginPrompts = true;
        IdentityProvider ldapIdentityProvider = null;
        try {
            ldapIdentityProvider = this.providerProvisioning.retrieveByOrigin("ldap", IdentityZoneHolder.get().getId());
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        IdentityProvider uaaIdentityProvider = this.providerProvisioning.retrieveByOriginIgnoreActiveFlag("uaa", IdentityZoneHolder.get().getId());
        if (!(uaaIdentityProvider.isActive() || ldapIdentityProvider != null && ldapIdentityProvider.isActive())) {
            fieldUsernameShow = false;
            returnLoginPrompts = false;
        }
        if (!(allowedIdentityProviderKeys == null || allowedIdentityProviderKeys.contains("ldap") || allowedIdentityProviderKeys.contains("uaa") || allowedIdentityProviderKeys.contains("keystone"))) {
            fieldUsernameShow = false;
        }
        Map.Entry idpForRedirect = null;
        idpForRedirect = this.evaluateLoginHint(model, session, samlIdentityProviders, oauthIdentityProviders, (Map<String, AbstractIdentityProviderDefinition>)allIdentityProviders, allowedIdentityProviderKeys, request);
        boolean discoveryEnabled = IdentityZoneHolder.get().getConfig().isIdpDiscoveryEnabled();
        if ((idpForRedirect = this.evaluateIdpDiscovery(model, samlIdentityProviders, oauthIdentityProviders, (Map<String, AbstractIdentityProviderDefinition>)allIdentityProviders, allowedIdentityProviderKeys, idpForRedirect, discoveryEnabled, discoveryPerformed = Boolean.parseBoolean(request.getParameter("discoveryPerformed")), defaultIdentityProviderName = IdentityZoneHolder.get().getConfig().getDefaultIdentityProvider())) == null && !jsonResponse && !fieldUsernameShow && allIdentityProviders.size() == 1) {
            idpForRedirect = (Map.Entry)allIdentityProviders.entrySet().stream().findAny().get();
        }
        if (idpForRedirect != null && (externalRedirect = this.redirectToExternalProvider(idpForRedirect.getValue(), idpForRedirect.getKey(), request)) != null && !jsonResponse) {
            logger.debug((Object)("Following external redirect : " + externalRedirect));
            return externalRedirect;
        }
        boolean linkCreateAccountShow = fieldUsernameShow;
        if (fieldUsernameShow && allowedIdentityProviderKeys != null) {
            if (!allowedIdentityProviderKeys.contains("uaa")) {
                linkCreateAccountShow = false;
                model.addAttribute("login_hint", (Object)new UaaLoginHint("ldap").toString());
            } else if (!allowedIdentityProviderKeys.contains("ldap")) {
                model.addAttribute("login_hint", (Object)new UaaLoginHint("uaa").toString());
            }
        }
        String zonifiedEntityID = this.getZonifiedEntityId();
        Map<String, ?> links = this.getLinksInfo();
        if (jsonResponse) {
            this.setJsonInfo(model, samlIdentityProviders, zonifiedEntityID, links);
        } else {
            this.updateLoginPageModel(model, request, clientName, samlIdentityProviders, oauthIdentityProviders, fieldUsernameShow, linkCreateAccountShow);
        }
        model.addAttribute(LINKS, links);
        this.setCommitInfo(model);
        model.addAttribute(ZONE_NAME, (Object)IdentityZoneHolder.get().getName());
        model.addAttribute(ENTITY_ID, (Object)zonifiedEntityID);
        excludedPrompts = new LinkedList<String>(excludedPrompts);
        String origin = request != null ? request.getParameter("origin") : null;
        this.populatePrompts(model, excludedPrompts, origin, samlIdentityProviders, oauthIdentityProviders, excludedPrompts, returnLoginPrompts);
        if (principal == null) {
            return this.getUnauthenticatedRedirect(model, request, discoveryEnabled, discoveryPerformed);
        }
        return "home";
    }

    private String getUnauthenticatedRedirect(Model model, HttpServletRequest request, boolean discoveryEnabled, boolean discoveryPerformed) {
        String formRedirectUri = request.getParameter("form_redirect_uri");
        if (StringUtils.hasText((String)formRedirectUri)) {
            model.addAttribute("form_redirect_uri", (Object)formRedirectUri);
        }
        boolean accountChooserEnabled = IdentityZoneHolder.get().getConfig().isAccountChooserEnabled();
        boolean otherAccountSignIn = Boolean.parseBoolean(request.getParameter("otherAccountSignIn"));
        boolean savedAccountsEmpty = LoginInfoEndpoint.getSavedAccounts(request.getCookies(), SavedAccountOption.class).isEmpty();
        if (discoveryEnabled) {
            boolean accountChooserNeeded;
            if (model.containsAttribute("login_hint")) {
                return this.goToPasswordPage(null, model);
            }
            boolean bl = accountChooserNeeded = accountChooserEnabled && !otherAccountSignIn && !savedAccountsEmpty && !discoveryPerformed;
            if (accountChooserNeeded) {
                return "idp_discovery/account_chooser";
            }
            if (!discoveryPerformed) {
                return "idp_discovery/email";
            }
            return this.goToPasswordPage(request.getParameter("email"), model);
        }
        return "login";
    }

    private void updateLoginPageModel(Model model, HttpServletRequest request, String clientName, Map<String, SamlIdentityProviderDefinition> samlIdentityProviders, Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviders, boolean fieldUsernameShow, boolean linkCreateAccountShow) {
        model.addAttribute(LINK_CREATE_ACCOUNT_SHOW, (Object)linkCreateAccountShow);
        model.addAttribute(FIELD_USERNAME_SHOW, (Object)fieldUsernameShow);
        model.addAttribute(IDP_DEFINITIONS, samlIdentityProviders.values());
        HashMap oauthLinks = new HashMap();
        Optional.ofNullable(oauthIdentityProviders).orElse(Collections.emptyMap()).entrySet().stream().filter(e -> ((AbstractXOAuthIdentityProviderDefinition)e.getValue()).isShowLinkText()).forEach(e -> oauthLinks.put(this.xoAuthProviderConfigurator.getCompleteAuthorizationURI((String)e.getKey(), UaaUrlUtils.getBaseURL(request), (AbstractXOAuthIdentityProviderDefinition)e.getValue()), ((AbstractXOAuthIdentityProviderDefinition)e.getValue()).getLinkText()));
        model.addAttribute(OAUTH_LINKS, oauthLinks);
        model.addAttribute("clientName", (Object)clientName);
    }

    private void setJsonInfo(Model model, Map<String, SamlIdentityProviderDefinition> samlIdentityProviders, String zonifiedEntityID, Map links) {
        for (String attribute : UI_ONLY_ATTRIBUTES) {
            links.remove(attribute);
        }
        HashMap<String, String> idpDefinitionsForJson = new HashMap<String, String>();
        if (samlIdentityProviders != null) {
            for (SamlIdentityProviderDefinition def : samlIdentityProviders.values()) {
                String idpUrl = links.get("login") + String.format("/saml/discovery?returnIDParam=idp&entityID=%s&idp=%s&isPassive=true", zonifiedEntityID, def.getIdpEntityAlias());
                idpDefinitionsForJson.put(def.getIdpEntityAlias(), idpUrl);
            }
            model.addAttribute(IDP_DEFINITIONS, idpDefinitionsForJson);
        }
    }

    private Map.Entry<String, AbstractIdentityProviderDefinition> evaluateIdpDiscovery(Model model, Map<String, SamlIdentityProviderDefinition> samlIdentityProviders, Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviders, Map<String, AbstractIdentityProviderDefinition> allIdentityProviders, List<String> allowedIdentityProviderKeys, Map.Entry<String, AbstractIdentityProviderDefinition> idpForRedirect, boolean discoveryEnabled, boolean discoveryPerformed, String defaultIdentityProviderName) {
        if (!(idpForRedirect != null || !discoveryPerformed && discoveryEnabled || defaultIdentityProviderName == null || model.containsAttribute("login_hint"))) {
            if (!"uaa".equals(defaultIdentityProviderName) && !"ldap".equals(defaultIdentityProviderName)) {
                if (allIdentityProviders.containsKey(defaultIdentityProviderName)) {
                    idpForRedirect = allIdentityProviders.entrySet().stream().filter(entry -> defaultIdentityProviderName.equals(entry.getKey())).findAny().orElse(null);
                }
            } else if (allowedIdentityProviderKeys == null || allowedIdentityProviderKeys.contains(defaultIdentityProviderName)) {
                UaaLoginHint loginHint = new UaaLoginHint(defaultIdentityProviderName);
                model.addAttribute("login_hint", (Object)loginHint.toString());
                samlIdentityProviders.clear();
                oauthIdentityProviders.clear();
            }
        }
        return idpForRedirect;
    }

    private Map.Entry<String, AbstractIdentityProviderDefinition> evaluateLoginHint(Model model, HttpSession session, Map<String, SamlIdentityProviderDefinition> samlIdentityProviders, Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviders, Map<String, AbstractIdentityProviderDefinition> allIdentityProviders, List<String> allowedIdentityProviderKeys, HttpServletRequest request) {
        Map.Entry idpForRedirect = null;
        String loginHintParam = Optional.ofNullable(session).flatMap(s -> Optional.ofNullable((SavedRequest)s.getAttribute("SPRING_SECURITY_SAVED_REQUEST"))).flatMap(sr -> Optional.ofNullable(sr.getParameterValues("login_hint"))).flatMap(lhValues -> Arrays.asList(lhValues).stream().findFirst()).orElse(request.getParameter("login_hint"));
        if (loginHintParam != null) {
            String loginHint = loginHintParam;
            UaaLoginHint uaaLoginHint = UaaLoginHint.parseRequestParameter(loginHint);
            if (uaaLoginHint != null) {
                logger.debug((Object)("Received login hint: " + loginHint));
                logger.debug((Object)("Received login hint with origin: " + uaaLoginHint.getOrigin()));
                if ("uaa".equals(uaaLoginHint.getOrigin()) || "ldap".equals(uaaLoginHint.getOrigin())) {
                    if (allowedIdentityProviderKeys == null || allowedIdentityProviderKeys.contains(uaaLoginHint.getOrigin())) {
                        model.addAttribute("login_hint", (Object)loginHint);
                        samlIdentityProviders.clear();
                        oauthIdentityProviders.clear();
                    } else {
                        model.addAttribute("error", (Object)"invalid_login_hint");
                    }
                } else {
                    List hintIdentityProviders = allIdentityProviders.entrySet().stream().filter(idp -> ((String)idp.getKey()).equals(uaaLoginHint.getOrigin())).collect(Collectors.toList());
                    if (hintIdentityProviders.size() > 1) {
                        throw new IllegalStateException("There is a misconfiguration with the identity provider(s). Please contact your system administrator.");
                    }
                    if (hintIdentityProviders.size() == 1) {
                        idpForRedirect = (Map.Entry)hintIdentityProviders.get(0);
                        logger.debug((Object)("Setting redirect from origin login_hint to: " + idpForRedirect));
                    } else {
                        logger.debug((Object)("Client does not allow provider for login_hint with origin key: " + uaaLoginHint.getOrigin()));
                        model.addAttribute("error", (Object)"invalid_login_hint");
                    }
                }
            } else {
                List matchingIdentityProviders = allIdentityProviders.entrySet().stream().filter(idp -> Optional.ofNullable(((AbstractIdentityProviderDefinition)idp.getValue()).getEmailDomain()).orElse(Collections.emptyList()).contains(loginHint)).collect(Collectors.toList());
                if (matchingIdentityProviders.size() > 1) {
                    throw new IllegalStateException("There is a misconfiguration with the identity provider(s). Please contact your system administrator.");
                }
                if (matchingIdentityProviders.size() == 1) {
                    idpForRedirect = (Map.Entry)matchingIdentityProviders.get(0);
                    logger.debug((Object)("Setting redirect from email domain login hint to: " + idpForRedirect));
                }
            }
        }
        return idpForRedirect;
    }

    @RequestMapping(value={"/delete_saved_account"})
    public String deleteSavedAccount(HttpServletRequest request, HttpServletResponse response, String userId) {
        Cookie cookie = new Cookie("Saved-Account-" + userId, "");
        cookie.setMaxAge(0);
        cookie.setPath(request.getContextPath() + "/login");
        response.addCookie(cookie);
        return "redirect:/login";
    }

    private String redirectToExternalProvider(AbstractIdentityProviderDefinition idpForRedirect, String alias, HttpServletRequest request) {
        if (idpForRedirect != null) {
            if (idpForRedirect instanceof SamlIdentityProviderDefinition) {
                String url = SamlRedirectUtils.getIdpRedirectUrl((SamlIdentityProviderDefinition)idpForRedirect, this.entityID);
                return "redirect:/" + url;
            }
            if (idpForRedirect instanceof AbstractXOAuthIdentityProviderDefinition) {
                try {
                    String redirectUrl = this.getRedirectUrlForXOAuthIDP(request, alias, (AbstractXOAuthIdentityProviderDefinition)idpForRedirect);
                    return "redirect:" + redirectUrl;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String getRedirectUrlForXOAuthIDP(HttpServletRequest request, String alias, AbstractXOAuthIdentityProviderDefinition definition) throws UnsupportedEncodingException {
        return this.xoAuthProviderConfigurator.getCompleteAuthorizationURI(alias, UaaUrlUtils.getBaseURL(request), definition);
    }

    protected Map<String, SamlIdentityProviderDefinition> getSamlIdentityProviderDefinitions(List<String> allowedIdps) {
        List<SamlIdentityProviderDefinition> filteredIdps = this.idpDefinitions.getIdentityProviderDefinitions(allowedIdps, IdentityZoneHolder.get());
        return (Map)filteredIdps.stream().collect(new MapCollector<SamlIdentityProviderDefinition, String, SamlIdentityProviderDefinition>(SamlIdentityProviderDefinition::getIdpEntityAlias, idp -> idp));
    }

    protected Map<String, AbstractXOAuthIdentityProviderDefinition> getOauthIdentityProviderDefinitions(List<String> allowedIdps) {
        List<IdentityProvider> identityProviders = this.xoAuthProviderConfigurator.retrieveAll(true, IdentityZoneHolder.get().getId());
        Map identityProviderDefinitions = (Map)identityProviders.stream().filter(p -> allowedIdps == null || allowedIdps.contains(p.getOriginKey())).collect(this.idpsMapCollector);
        return identityProviderDefinitions;
    }

    protected boolean hasSavedOauthAuthorizeRequest(HttpSession session) {
        if (session == null || session.getAttribute("SPRING_SECURITY_SAVED_REQUEST") == null) {
            return false;
        }
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        String redirectUrl = savedRequest.getRedirectUrl();
        String[] client_ids = savedRequest.getParameterValues("client_id");
        return redirectUrl != null && redirectUrl.contains("/oauth/authorize") && client_ids != null && client_ids.length != 0;
    }

    public Map<String, Object> getClientInfo(HttpSession session) {
        if (!this.hasSavedOauthAuthorizeRequest(session)) {
            return null;
        }
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        String[] client_ids = savedRequest.getParameterValues("client_id");
        try {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(client_ids[0], IdentityZoneHolder.get().getId());
            return clientDetails.getAdditionalInformation();
        }
        catch (NoSuchClientException x) {
            return null;
        }
    }

    private void setCommitInfo(Model model) {
        model.addAttribute("commit_id", (Object)this.gitProperties.getProperty("git.commit.id.abbrev", "UNKNOWN"));
        model.addAttribute("timestamp", (Object)this.gitProperties.getProperty("git.commit.time", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date())));
        model.addAttribute("app", (Object)UaaStringUtils.getMapFromProperties((Properties)this.buildProperties, (String)"build."));
    }

    private void populatePrompts(Model model, List<String> exclude, String origin, Map<String, SamlIdentityProviderDefinition> samlIdentityProviders, Map<String, AbstractXOAuthIdentityProviderDefinition> oauthIdentityProviders, List<String> excludedPrompts, boolean returnLoginPrompts) {
        IdentityZoneConfiguration zoneConfiguration;
        boolean noIdpsPresent = true;
        for (SamlIdentityProviderDefinition idp : samlIdentityProviders.values()) {
            if (!idp.isShowSamlLink()) continue;
            model.addAttribute(SHOW_LOGIN_LINKS, (Object)true);
            noIdpsPresent = false;
            break;
        }
        for (AbstractXOAuthIdentityProviderDefinition oauthIdp : oauthIdentityProviders.values()) {
            if (!oauthIdp.isShowLinkText()) continue;
            model.addAttribute(SHOW_LOGIN_LINKS, (Object)true);
            noIdpsPresent = false;
            break;
        }
        if (noIdpsPresent) {
            excludedPrompts.add(PASSCODE);
        }
        if (!returnLoginPrompts) {
            excludedPrompts.add("username");
            excludedPrompts.add("password");
        }
        if (Objects.isNull(zoneConfiguration = IdentityZoneHolder.get().getConfig())) {
            zoneConfiguration = new IdentityZoneConfiguration();
        }
        List prompts = zoneConfiguration.getPrompts();
        if (origin != null) {
            OIDCIdentityProviderDefinition oidcConfig;
            List providerPrompts;
            IdentityProvider providerForOrigin = null;
            try {
                providerForOrigin = this.providerProvisioning.retrieveByOrigin(origin, IdentityZoneHolder.get().getId());
            }
            catch (DataAccessException dataAccessException) {
                // empty catch block
            }
            if (providerForOrigin != null && providerForOrigin.getConfig() instanceof OIDCIdentityProviderDefinition && (providerPrompts = (oidcConfig = (OIDCIdentityProviderDefinition)providerForOrigin.getConfig()).getPrompts()) != null) {
                prompts = providerPrompts;
            }
        }
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (Prompt prompt : prompts) {
            String urlInPasscode;
            String[] details = prompt.getDetails();
            if (PASSCODE.equals(prompt.getName()) && !IdentityZoneHolder.isUaa() && StringUtils.hasText((String)(urlInPasscode = this.extractUrlFromString(prompt.getDetails()[1])))) {
                String[] newDetails = new String[details.length];
                System.arraycopy(details, 0, newDetails, 0, details.length);
                newDetails[1] = newDetails[1].replace(urlInPasscode, UaaUrlUtils.addSubdomainToUrl(urlInPasscode, IdentityZoneHolder.get().getSubdomain()));
                details = newDetails;
            }
            map.put(prompt.getName(), details);
        }
        if (this.mfaChecker.isMfaEnabled(IdentityZoneHolder.get(), "uaa")) {
            Prompt p = new Prompt(MFA_CODE, "password", "MFA Code ( Register at " + UaaUrlUtils.addSubdomainToUrl(this.getBaseUrl() + " )", IdentityZoneHolder.get().getSubdomain()));
            map.putIfAbsent(p.getName(), p.getDetails());
        }
        for (String excludeThisPrompt : exclude) {
            map.remove(excludeThisPrompt);
        }
        model.addAttribute("prompts", map);
    }

    public String extractUrlFromString(String s) {
        Matcher matcher = urlPattern.matcher(s);
        if (matcher.find()) {
            int matchStart = matcher.start(0);
            int matchEnd = matcher.end(0);
            return s.substring(matchStart, matchEnd);
        }
        return null;
    }

    @RequestMapping(value={"/login/idp_discovery"}, method={RequestMethod.POST})
    public String discoverIdentityProvider(@RequestParam String email, @RequestParam(required=false) String skipDiscovery, @RequestParam(required=false, name="login_hint") String loginHint, Model model, HttpSession session, HttpServletRequest request) {
        ClientDetails clientDetails = null;
        if (this.hasSavedOauthAuthorizeRequest(session)) {
            SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
            String[] client_ids = savedRequest.getParameterValues("client_id");
            try {
                clientDetails = this.clientDetailsService.loadClientByClientId(client_ids[0], IdentityZoneHolder.get().getId());
            }
            catch (NoSuchClientException noSuchClientException) {
                // empty catch block
            }
        }
        if (StringUtils.hasText((String)loginHint)) {
            model.addAttribute("login_hint", (Object)loginHint);
        }
        List<IdentityProvider> identityProviders = DomainFilter.filter(this.providerProvisioning.retrieveActive(IdentityZoneHolder.get().getId()), clientDetails, email, false);
        if (!StringUtils.hasText((String)skipDiscovery) && identityProviders.size() == 1) {
            IdentityProvider matchedIdp = identityProviders.get(0);
            if (matchedIdp.getType().equals("uaa")) {
                model.addAttribute("login_hint", (Object)new UaaLoginHint("uaa").toString());
                return this.goToPasswordPage(email, model);
            }
            String redirectUrl = this.redirectToExternalProvider(matchedIdp.getConfig(), matchedIdp.getOriginKey(), request);
            if (redirectUrl != null) {
                return redirectUrl;
            }
        }
        if (StringUtils.hasText((String)email)) {
            model.addAttribute("email", (Object)email);
        }
        return "redirect:/login?discoveryPerformed=true";
    }

    private String goToPasswordPage(String email, Model model) {
        model.addAttribute(ZONE_NAME, (Object)IdentityZoneHolder.get().getName());
        model.addAttribute("email", (Object)email);
        String forgotPasswordLink = this.getSelfServiceLinks().get(FORGOT_PASSWORD_LINK);
        if (forgotPasswordLink != null) {
            model.addAttribute(FORGOT_PASSWORD_LINK, (Object)forgotPasswordLink);
        }
        return "idp_discovery/password";
    }

    @RequestMapping(value={"/autologin"}, method={RequestMethod.POST})
    @ResponseBody
    public AutologinResponse generateAutologinCode(@RequestBody AutologinRequest request, @RequestHeader(value="Authorization", required=false) String auth) throws Exception {
        UaaPrincipal p;
        if (this.mfaChecker.isMfaEnabled(IdentityZoneHolder.get(), "uaa")) {
            throw new BadCredentialsException("MFA is required");
        }
        if (auth == null || !auth.startsWith("Basic")) {
            throw new BadCredentialsException("No basic authorization client information in request");
        }
        String username = request.getUsername();
        if (username == null) {
            throw new BadCredentialsException("No username in request");
        }
        Authentication userAuthentication = null;
        if (this.authenticationManager != null) {
            String password = request.getPassword();
            if (!StringUtils.hasText((String)password)) {
                throw new BadCredentialsException("No password in request");
            }
            userAuthentication = this.authenticationManager.authenticate((Authentication)new AuthzAuthenticationRequest(username, password, null));
        }
        String base64Credentials = auth.substring("Basic".length()).trim();
        new Base64();
        String credentials = new String(Base64.decode((byte[])base64Credentials.getBytes()), StandardCharsets.UTF_8.name());
        String[] values = credentials.split(":", 2);
        if (values == null || values.length == 0) {
            throw new BadCredentialsException("Invalid authorization header.");
        }
        String clientId = values[0];
        HashMap<String, String> codeData = new HashMap<String, String>();
        codeData.put("client_id", clientId);
        codeData.put("username", username);
        if (userAuthentication != null && userAuthentication.getPrincipal() instanceof UaaPrincipal && (p = (UaaPrincipal)userAuthentication.getPrincipal()) != null) {
            codeData.put("user_id", p.getId());
            codeData.put("origin", p.getOrigin());
        }
        ExpiringCode expiringCode = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString(codeData), new Timestamp(System.currentTimeMillis() + 300000L), ExpiringCodeType.AUTOLOGIN.name(), IdentityZoneHolder.get().getId());
        return new AutologinResponse(expiringCode.getCode());
    }

    @RequestMapping(value={"/autologin"}, method={RequestMethod.GET})
    public String performAutologin(HttpSession session) {
        if (this.mfaChecker.isMfaEnabled(IdentityZoneHolder.get(), "uaa")) {
            throw new BadCredentialsException("MFA is required");
        }
        String redirectLocation = "home";
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        if (savedRequest != null && savedRequest.getRedirectUrl() != null) {
            redirectLocation = savedRequest.getRedirectUrl();
        }
        return "redirect:" + redirectLocation;
    }

    @RequestMapping(value={"/login_implicit"}, method={RequestMethod.GET})
    public String captureImplicitValuesUsingJavascript() {
        return "login_implicit";
    }

    @RequestMapping(value={"/login/callback/{origin}"})
    public String handleXOAuthCallback(HttpSession session) {
        String redirectLocation = "/home";
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        if (savedRequest != null && savedRequest.getRedirectUrl() != null) {
            redirectLocation = savedRequest.getRedirectUrl();
        }
        return "redirect:" + redirectLocation;
    }

    @RequestMapping(value={"/passcode"}, method={RequestMethod.GET})
    public String generatePasscode(Map<String, Object> model, Principal principal) throws NoSuchAlgorithmException, IOException {
        String origin;
        String username;
        UaaPrincipal uaaPrincipal;
        String userId = NotANumber;
        Map<String, Object> authorizationParameters = null;
        if (principal instanceof UaaPrincipal) {
            uaaPrincipal = (UaaPrincipal)principal;
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else if (principal instanceof UaaAuthentication) {
            uaaPrincipal = ((UaaAuthentication)((Object)principal)).getPrincipal();
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else if (principal instanceof LoginSamlAuthenticationToken) {
            username = principal.getName();
            origin = ((LoginSamlAuthenticationToken)((Object)principal)).getUaaPrincipal().getOrigin();
            userId = ((LoginSamlAuthenticationToken)((Object)principal)).getUaaPrincipal().getId();
        } else if (principal instanceof Authentication && ((Authentication)principal).getPrincipal() instanceof UaaPrincipal) {
            uaaPrincipal = (UaaPrincipal)((Authentication)principal).getPrincipal();
            username = uaaPrincipal.getName();
            origin = uaaPrincipal.getOrigin();
            userId = uaaPrincipal.getId();
        } else {
            throw new UnknownPrincipalException();
        }
        PasscodeInformation pi = new PasscodeInformation(userId, username, null, origin, authorizationParameters);
        String intent = (Object)((Object)ExpiringCodeType.PASSCODE) + " " + pi.getUserId();
        this.expiringCodeStore.expireByIntent(intent, IdentityZoneHolder.get().getId());
        ExpiringCode code = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString((Object)pi), new Timestamp(System.currentTimeMillis() + this.getCodeExpirationMillis()), intent, IdentityZoneHolder.get().getId());
        model.put(PASSCODE, code.getCode());
        return PASSCODE;
    }

    protected Map<String, ?> getLinksInfo() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("uaa", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl(), IdentityZoneHolder.get().getSubdomain()));
        if (this.getBaseUrl().contains("localhost:")) {
            model.put("login", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl(), IdentityZoneHolder.get().getSubdomain()));
        } else if (StringUtils.hasText((String)this.getExternalLoginUrl())) {
            model.put("login", this.getExternalLoginUrl());
        } else {
            model.put("login", UaaUrlUtils.addSubdomainToUrl(this.getUaaBaseUrl().replaceAll("uaa", "login"), IdentityZoneHolder.get().getSubdomain()));
        }
        model.putAll(this.getSelfServiceLinks());
        return model;
    }

    protected Map<String, String> getSelfServiceLinks() {
        HashMap<String, String> selfServiceLinks = new HashMap<String, String>();
        IdentityZone zone = IdentityZoneHolder.get();
        IdentityProvider uaaIdp = this.providerProvisioning.retrieveByOriginIgnoreActiveFlag("uaa", IdentityZoneHolder.get().getId());
        boolean disableInternalUserManagement = uaaIdp.getConfig() != null ? ((UaaIdentityProviderDefinition)uaaIdp.getConfig()).isDisableInternalUserManagement() : false;
        boolean selfServiceLinksEnabled = zone.getConfig() != null ? zone.getConfig().getLinks().getSelfService().isSelfServiceLinksEnabled() : true;
        String defaultSignup = "/create_account";
        String defaultPasswd = "/forgot_password";
        Links.SelfService service = zone.getConfig() != null ? zone.getConfig().getLinks().getSelfService() : null;
        String signup = UaaStringUtils.nonNull((String[])new String[]{service != null ? service.getSignup() : null, this.globalLinks.getSelfService().getSignup(), "/create_account"});
        String passwd = UaaStringUtils.nonNull((String[])new String[]{service != null ? service.getPasswd() : null, this.globalLinks.getSelfService().getPasswd(), "/forgot_password"});
        if (selfServiceLinksEnabled && !disableInternalUserManagement) {
            if (StringUtils.hasText((String)signup)) {
                signup = UaaStringUtils.replaceZoneVariables((String)signup, (IdentityZone)IdentityZoneHolder.get());
                selfServiceLinks.put(CREATE_ACCOUNT_LINK, signup);
                selfServiceLinks.put("register", signup);
            }
            if (StringUtils.hasText((String)passwd)) {
                passwd = UaaStringUtils.replaceZoneVariables((String)passwd, (IdentityZone)IdentityZoneHolder.get());
                selfServiceLinks.put(FORGOT_PASSWORD_LINK, passwd);
                selfServiceLinks.put("passwd", passwd);
            }
        }
        return selfServiceLinks;
    }

    public void setUaaBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        try {
            URI uri = new URI(baseUrl);
            this.setUaaHost(uri.getHost());
            if (uri.getPort() != 443 && uri.getPort() != 80 && uri.getPort() > 0) {
                this.setUaaHost(this.getUaaHost() + ":" + uri.getPort());
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not extract host from URI: " + baseUrl);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected String getUaaBaseUrl() {
        return this.baseUrl;
    }

    public String getUaaHost() {
        return this.uaaHost;
    }

    public void setUaaHost(String uaaHost) {
        this.uaaHost = uaaHost;
    }

    public void setExternalLoginUrl(String baseUrl) {
        this.externalLoginUrl = baseUrl;
    }

    public String getExternalLoginUrl() {
        return this.externalLoginUrl;
    }

    public String getSamlSPBaseUrl() {
        return this.samlSPBaseUrl;
    }

    public void setSamlSPBaseUrl(String samlSPBaseUrl) {
        this.samlSPBaseUrl = samlSPBaseUrl;
    }

    protected String extractPath(HttpServletRequest request) {
        String query = request.getQueryString();
        try {
            query = query == null ? "" : "?" + URLDecoder.decode(query, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot decode query string: " + query);
        }
        String path = request.getRequestURI() + query;
        String context = request.getContextPath();
        path = path.substring(context.length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public void setClientDetailsService(ClientServicesExtension clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public IdentityProviderProvisioning getProviderProvisioning() {
        return this.providerProvisioning;
    }

    public void setProviderProvisioning(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Unknown authentication token type, unable to derive user ID.")
    public static final class UnknownPrincipalException
    extends RuntimeException {
    }

    static class SavedAccountOptionModel
    extends SavedAccountOption {
        public int red;
        public int green;
        public int blue;

        SavedAccountOptionModel() {
        }

        public void assignColors(Color color) {
            this.red = color.getRed();
            this.blue = color.getBlue();
            this.green = color.getGreen();
        }
    }
}

