/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class NestedMapPropertySource
extends MapPropertySource {
    private Map<String, Object> cache = new HashMap<String, Object>();
    private boolean initialized = false;

    public NestedMapPropertySource(String name, Map<String, ?> source) {
        super(name, source);
    }

    public Object getProperty(String name) {
        Object value = ((Map)this.source).get(name);
        if (value != null) {
            return value;
        }
        this.populateCache();
        value = this.cache.get(name);
        return value;
    }

    public boolean containsProperty(String name) {
        return null != this.getProperty(name);
    }

    public String[] getPropertyNames() {
        this.populateCache();
        return this.cache.keySet().toArray(new String[0]);
    }

    private void populateCache() {
        if (this.initialized) {
            return;
        }
        this.appendCache(this.cache, new HashSet<String>(), (Map)this.source, null);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendCache(Map<String, Object> output, Set<String> seen, Map<String, Object> input, String path) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            seen.add(ObjectUtils.getIdentityHexString(input));
            for (Map.Entry<String, Object> entry : input.entrySet()) {
                Object value;
                String key = entry.getKey();
                if (StringUtils.hasText((String)path)) {
                    key = key.startsWith("[") ? path + key : path + "." + key;
                }
                if ((value = entry.getValue()) instanceof String) {
                    output.put(key, value);
                    continue;
                }
                if (value instanceof Map) {
                    Map map2 = (Map)value;
                    output.put(key, map2);
                    if (seen.contains(ObjectUtils.getIdentityHexString((Object)map2))) continue;
                    this.appendCache(output, seen, map2, key);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    output.put(key, collection);
                    int count = 0;
                    for (Object object : collection) {
                        String index = "[" + count++ + "]";
                        if (!seen.contains(ObjectUtils.getIdentityHexString(object))) {
                            this.appendCache(output, seen, Collections.singletonMap(index, object), key);
                            continue;
                        }
                        output.put(key + index, object);
                    }
                    continue;
                }
                output.put(key, value);
            }
        }
    }
}

