/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.db;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class Create_Groups_For_Zones_2_5_2
implements SpringJdbcMigration {
    private static Log logger = LogFactory.getLog(Create_Groups_For_Zones_2_5_2.class);

    public void migrate(JdbcTemplate jdbcTemplate) throws Exception {
        String groupCreateSQL = "INSERT INTO groups (id,displayName,created,lastModified,version,identity_zone_id) VALUES (?,?,?,?,?,?)";
        HashMap zoneIdToGroupNameToGroupId = new HashMap();
        List zones = jdbcTemplate.queryForList("SELECT id FROM identity_zone WHERE id <> 'uaa'", String.class);
        List groups = jdbcTemplate.queryForList("SELECT displayName FROM groups WHERE identity_zone_id = 'uaa'", String.class);
        for (String zoneId : zones) {
            HashMap<String, String> groupNameToGroupId = new HashMap<String, String>();
            zoneIdToGroupNameToGroupId.put(zoneId, groupNameToGroupId);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (String displayName : groups) {
                if (displayName.startsWith("zones.")) continue;
                String id = UUID.randomUUID().toString();
                jdbcTemplate.update(groupCreateSQL, new Object[]{id, displayName, now, now, 0, zoneId});
                groupNameToGroupId.put(displayName, id);
            }
        }
        String userSQL = "SELECT gm.group_id, gm.member_id, g.displayName, u.identity_zone_id FROM group_membership gm, groups g, users u WHERE gm.member_type='USER' AND gm.member_id = u.id AND gm.group_id = g.id AND u.identity_zone_id <> 'uaa'";
        List userMembers = jdbcTemplate.queryForList(userSQL);
        for (Map userRow : userMembers) {
            String displayName;
            String zoneId = (String)userRow.get("identity_zone_id");
            displayName = (String)userRow.get("displayName");
            String memberId = (String)userRow.get("member_id");
            String oldGroupId = (String)userRow.get("group_id");
            Map groupNameToGroupId = (Map)zoneIdToGroupNameToGroupId.get(zoneId);
            if (groupNameToGroupId == null) {
                int count = jdbcTemplate.update("DELETE FROM group_membership WHERE group_id=? AND member_id=?", new Object[]{oldGroupId, memberId});
                if (count == 1) continue;
                logger.error((Object)("Unable to delete membership for non existent zone(group:" + oldGroupId + ", member:" + memberId + ")"));
                continue;
            }
            String groupId = (String)groupNameToGroupId.get(displayName);
            if (StringUtils.hasText((String)groupId)) {
                int count = jdbcTemplate.update("UPDATE group_membership SET group_id=? WHERE group_id=? AND member_id=?", new Object[]{groupId, oldGroupId, memberId});
                if (count == 1) continue;
                logger.error((Object)("Unable to update group membership for migrated zone(old group:" + oldGroupId + ", member:" + memberId + ", new group:" + groupId + ")"));
                continue;
            }
            logger.error((Object)("Will not migrate (old group:" + oldGroupId + ", member:" + memberId + ", new group:" + groupId + "). Incorrectly mapped zones group? (" + displayName + ")"));
        }
        userMembers.clear();
    }
}

