/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.cypto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.directory.api.util.Strings;
import org.cloudfoundry.identity.uaa.cypto.EncryptionService;
import org.cloudfoundry.identity.uaa.cypto.EncryptionServiceException;
import org.cloudfoundry.identity.uaa.cypto.NoActiveEncryptionKeyProvided;

public class EncryptionKeyService {
    private final EncryptionKey activeKey;
    private final List<EncryptionKey> encryptionKeys;

    public EncryptionKeyService(String activeKeyLabel, List<EncryptionKey> encryptionKeys) {
        if (Strings.isEmpty((String)activeKeyLabel)) {
            throw new NoActiveEncryptionKeyProvided("UAA cannot be started without encryption key value uaa.encryption.active_key_label");
        }
        List keysWithoutPassphrase = encryptionKeys.stream().filter(encryptionKey -> Strings.isEmpty((String)encryptionKey.getPassphrase())).collect(Collectors.toList());
        if (!keysWithoutPassphrase.isEmpty()) {
            throw new NoActiveEncryptionKeyProvided(String.format("UAA cannot be started as encryption key passphrase for uaa.encryption.encryption_keys/[%s] is undefined", String.join((CharSequence)", ", keysWithoutPassphrase.stream().map(s -> "label=" + s.getLabel()).collect(Collectors.toList()))));
        }
        List invalidLengthKeys = encryptionKeys.stream().filter(encryptionKey -> encryptionKey.getPassphrase().length() < 8).collect(Collectors.toList());
        if (!invalidLengthKeys.isEmpty()) {
            throw new NoActiveEncryptionKeyProvided(String.format("The required length of the encryption passphrases for [%s] need to be at least 8 characters long.", String.join((CharSequence)", ", invalidLengthKeys.stream().map(s -> "label=" + s.getLabel()).collect(Collectors.toList()))));
        }
        HashSet<String> keyCount = new HashSet<String>();
        ArrayList<String> duplicateKeyLabels = new ArrayList<String>();
        for (EncryptionKey encryptionKey2 : encryptionKeys) {
            if (keyCount.contains(encryptionKey2.getLabel())) {
                duplicateKeyLabels.add(encryptionKey2.getLabel());
                continue;
            }
            keyCount.add(encryptionKey2.getLabel());
        }
        if (!duplicateKeyLabels.isEmpty()) {
            throw new NoActiveEncryptionKeyProvided(String.format("UAA cannot be started as multiple keys have the same label in uaa.encryption.encryption_keys/[%s]", String.join((CharSequence)", ", duplicateKeyLabels.stream().map(s -> "label=" + s).collect(Collectors.toList()))));
        }
        this.encryptionKeys = encryptionKeys;
        this.activeKey = encryptionKeys.stream().filter(v -> v.getLabel().equals(activeKeyLabel)).findFirst().orElseGet(() -> {
            throw new NoActiveEncryptionKeyProvided(String.format("UAA cannot be started as encryption key passphrase for uaa.encryption.encryption_keys/[label=%s] is undefined", activeKeyLabel));
        });
    }

    public EncryptionKey getActiveKey() {
        return this.activeKey;
    }

    public Optional<EncryptionKey> getKey(String keyLabel) {
        for (EncryptionKey key : this.encryptionKeys) {
            if (!key.getLabel().equals(keyLabel)) continue;
            return Optional.of(key);
        }
        return Optional.empty();
    }

    public static class EncryptionKey
    extends HashMap<String, String> {
        private EncryptionService encryptionService;

        public String getLabel() {
            return (String)this.get("label");
        }

        public String getPassphrase() {
            return (String)this.get("passphrase");
        }

        public byte[] encrypt(String plaintext) throws EncryptionServiceException {
            if (this.encryptionService == null) {
                this.encryptionService = new EncryptionService(this.getPassphrase());
            }
            return this.encryptionService.encrypt(plaintext);
        }

        public byte[] decrypt(byte[] encrypt) throws EncryptionServiceException {
            if (this.encryptionService == null) {
                this.encryptionService = new EncryptionService(this.getPassphrase());
            }
            return this.encryptionService.decrypt(encrypt);
        }
    }
}

