/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client.event;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public abstract class AbstractClientAdminEvent
extends AbstractUaaEvent {
    private BaseClientDetails nonExistent = new BaseClientDetails("non-existent", "", "", "", "");
    private ClientDetails client;

    public AbstractClientAdminEvent(ClientDetails client, Authentication principal) {
        super(principal);
        this.client = client;
    }

    ClientDetails getClient() {
        return this.client;
    }

    Principal getPrincipal() {
        return this.getAuthentication();
    }

    abstract AuditEventType getAuditEventType();

    @Override
    public AuditEvent getAuditEvent() {
        ClientDetails clientDetails = Optional.ofNullable(this.getClient()).orElse((ClientDetails)this.nonExistent);
        HashMap<String, Collection<Object>> auditData = new HashMap<String, Collection<Object>>();
        auditData.put("scopes", clientDetails.getScope());
        List authorities = clientDetails.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.toList());
        auditData.put("authorities", authorities);
        return this.createAuditRecord(clientDetails.getClientId(), this.getAuditEventType(), this.getOrigin(this.getPrincipal()), JsonUtils.writeValueAsString(auditData));
    }
}

