/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class SocialClientUserDetails
extends AbstractAuthenticationToken {
    private String username;
    private String email;
    private String name;
    private Object id;
    private String source;

    @JsonCreator
    public SocialClientUserDetails(@JsonProperty(value="username") String username, @JsonProperty(value="authorities") @JsonDeserialize(contentAs=UaaAuthority.class) Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.setAuthenticated(authorities != null && !authorities.isEmpty());
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public Object getExternalId() {
        return this.id;
    }

    public void setExternalId(Object id) {
        this.id = id;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public String getName() {
        return this.username;
    }

    public void setFullName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getUsername() {
        return this.username;
    }

    @JsonIgnore
    public Object getCredentials() {
        return "N/A";
    }

    @JsonIgnore
    public Object getPrincipal() {
        return this.username;
    }

    public static class Source {
        public static String CLOUD_FOUNDRY = "cloudfoundry";
        public static String GITHUB = "github";
        public static String FACEBOOK = "facebook";
        public static String TWITTER = "twitter";
        public static String LINKEDIN = "linkedin";
        public static String GOOGLE = "google";

        public static String classify(String userInfoUrl) {
            String key = userInfoUrl.toLowerCase().replaceAll(".*//([a-z.]*)/.*", "$1");
            if (userInfoUrl.contains("cloudfoundry.com")) {
                key = CLOUD_FOUNDRY;
            } else if (userInfoUrl.contains("google.com") || userInfoUrl.contains("googleapis.com")) {
                key = GOOGLE;
            } else if (userInfoUrl.contains("github.com")) {
                key = GITHUB;
            } else if (userInfoUrl.contains("twitter.com")) {
                key = TWITTER;
            } else if (userInfoUrl.contains("linkedin.com")) {
                key = LINKEDIN;
            } else {
                String[] keys = key.split("\\.");
                if (keys.length > 1) {
                    key = keys[keys.length - 2];
                }
                if ("co".equals(key) && keys.length > 2) {
                    key = keys[keys.length - 3];
                }
            }
            return key;
        }
    }
}

