/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.audit.event.EntityDeletedEvent;
import org.cloudfoundry.identity.uaa.authentication.SystemAuthentication;
import org.cloudfoundry.identity.uaa.client.ClientMetadata;
import org.cloudfoundry.identity.uaa.client.ClientMetadataException;
import org.cloudfoundry.identity.uaa.client.ClientMetadataProvisioning;
import org.cloudfoundry.identity.uaa.client.InvalidClientDetailsException;
import org.cloudfoundry.identity.uaa.user.UaaAuthority;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.StringUtils;

public class ClientAdminBootstrap
implements InitializingBean,
ApplicationListener<ContextRefreshedEvent>,
ApplicationEventPublisherAware {
    private static Log logger = LogFactory.getLog(ClientAdminBootstrap.class);
    private Map<String, Map<String, Object>> clients = new HashMap<String, Map<String, Object>>();
    private List<String> clientsToDelete = null;
    private Collection<String> autoApproveClients = Collections.emptySet();
    private ClientServicesExtension clientRegistrationService;
    private ClientMetadataProvisioning clientMetadataProvisioning;
    private boolean defaultOverride = true;
    private final PasswordEncoder passwordEncoder;
    private ApplicationEventPublisher publisher;

    public ClientAdminBootstrap(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setDefaultOverride(boolean defaultOverride) {
        this.defaultOverride = defaultOverride;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setClients(Map<String, Map<String, Object>> clients) {
        this.clients = clients == null ? Collections.emptyMap() : new HashMap<String, Map<String, Object>>(clients);
    }

    public void setClientsToDelete(List<String> clientsToDelete) {
        this.clientsToDelete = clientsToDelete;
    }

    public void setAutoApproveClients(Collection<String> autoApproveClients) {
        this.autoApproveClients = autoApproveClients;
    }

    public void setClientRegistrationService(ClientServicesExtension clientRegistrationService) {
        this.clientRegistrationService = clientRegistrationService;
    }

    public void afterPropertiesSet() throws Exception {
        this.addNewClients();
        this.updateAutoApproveClients();
    }

    private void updateAutoApproveClients() {
        List slatedForDeletion = Optional.ofNullable(this.clientsToDelete).orElse(Collections.emptyList());
        LinkedList<String> autoApproveList = new LinkedList<String>(Optional.ofNullable(this.autoApproveClients).orElse(Collections.emptyList()));
        autoApproveList.removeIf(s -> slatedForDeletion.contains(s));
        for (String clientId : autoApproveList) {
            try {
                BaseClientDetails base = (BaseClientDetails)this.clientRegistrationService.loadClientByClientId(clientId, IdentityZone.getUaaZoneId());
                base.addAdditionalInformation("autoapprove", (Object)true);
                logger.debug((Object)("Adding autoapprove flag to client: " + clientId));
                this.clientRegistrationService.updateClientDetails((ClientDetails)base, IdentityZone.getUaaZoneId());
            }
            catch (NoSuchClientException n) {
                logger.debug((Object)("Client not found, unable to set autoapprove: " + clientId));
            }
        }
    }

    private String getRedirectUris(Map<String, Object> map) {
        HashSet<String> redirectUris = new HashSet<String>();
        if (map.get("redirect-uri") != null) {
            redirectUris.add((String)map.get("redirect-uri"));
        }
        if (map.get("signup_redirect_url") != null) {
            redirectUris.add((String)map.get("signup_redirect_url"));
        }
        if (map.get("change_email_redirect_url") != null) {
            redirectUris.add((String)map.get("change_email_redirect_url"));
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])redirectUris.toArray(new String[0]));
    }

    private void addNewClients() throws Exception {
        List slatedForDeletion = Optional.ofNullable(this.clientsToDelete).orElse(Collections.emptyList());
        Set<Map.Entry<String, Map<String, Object>>> entries = this.clients.entrySet();
        entries.removeIf(entry -> slatedForDeletion.contains(entry.getKey()));
        for (Map.Entry<String, Map<String, Object>> entry2 : entries) {
            String clientId = entry2.getKey();
            Map<String, Object> map = entry2.getValue();
            if (map.get("authorized-grant-types") == null) {
                throw new InvalidClientDetailsException("Client must have at least one authorized-grant-type. client ID: " + clientId);
            }
            BaseClientDetails client = new BaseClientDetails(clientId, (String)map.get("resource-ids"), (String)map.get("scope"), (String)map.get("authorized-grant-types"), (String)map.get("authorities"), this.getRedirectUris(map));
            client.setClientSecret(map.get("secret") == null ? "" : (String)map.get("secret"));
            Integer validity = (Integer)map.get("access-token-validity");
            Boolean override = (Boolean)map.get("override");
            if (override == null) {
                override = this.defaultOverride;
            }
            HashMap<String, Object> info = new HashMap<String, Object>(map);
            if (validity != null) {
                client.setAccessTokenValiditySeconds(validity);
            }
            if ((validity = (Integer)map.get("refresh-token-validity")) != null) {
                client.setRefreshTokenValiditySeconds(validity);
            }
            client.setResourceIds(Collections.singleton("none"));
            if (client.getScope().isEmpty()) {
                client.setScope(Collections.singleton("uaa.none"));
            }
            if (client.getAuthorities().isEmpty()) {
                client.setAuthorities(Collections.singleton(UaaAuthority.UAA_NONE));
            }
            if (client.getAuthorizedGrantTypes().contains("authorization_code")) {
                client.getAuthorizedGrantTypes().add("refresh_token");
            }
            for (String key : Arrays.asList("resource-ids", "scope", "authorized-grant-types", "authorities", "redirect-uri", "secret", "id", "override", "access-token-validity", "refresh-token-validity", "show-on-homepage", "app-launch-url", "app-icon")) {
                info.remove(key);
            }
            client.setAdditionalInformation(info);
            try {
                this.clientRegistrationService.addClientDetails((ClientDetails)client, IdentityZone.getUaaZoneId());
            }
            catch (ClientAlreadyExistsException e) {
                if (override == null || override.booleanValue()) {
                    logger.debug((Object)("Overriding client details for " + clientId));
                    this.clientRegistrationService.updateClientDetails((ClientDetails)client, IdentityZone.getUaaZoneId());
                    if (this.didPasswordChange(clientId, client.getClientSecret())) {
                        this.clientRegistrationService.updateClientSecret(clientId, client.getClientSecret(), IdentityZone.getUaaZoneId());
                    }
                }
                logger.debug((Object)e.getMessage());
            }
            for (String s : Arrays.asList("authorization_code", "implicit")) {
                if (!client.getAuthorizedGrantTypes().contains(s) || !this.isMissingRedirectUris(client)) continue;
                throw new InvalidClientDetailsException(s + " grant type requires at least one redirect URL. ClientID: " + client.getClientId());
            }
            ClientMetadata clientMetadata = this.buildClientMetadata(map, clientId);
            this.clientMetadataProvisioning.update(clientMetadata, IdentityZoneHolder.get().getId());
        }
    }

    private boolean isMissingRedirectUris(BaseClientDetails client) {
        return client.getRegisteredRedirectUri() == null || client.getRegisteredRedirectUri().isEmpty();
    }

    private ClientMetadata buildClientMetadata(Map<String, Object> map, String clientId) {
        Boolean showOnHomepage = (Boolean)map.get("show-on-homepage");
        String appLaunchUrl = (String)map.get("app-launch-url");
        String appIcon = (String)map.get("app-icon");
        ClientMetadata clientMetadata = new ClientMetadata();
        clientMetadata.setClientId(clientId);
        clientMetadata.setAppIcon(appIcon);
        clientMetadata.setShowOnHomePage(showOnHomepage != null && showOnHomepage != false);
        if (StringUtils.hasText((String)appLaunchUrl)) {
            try {
                clientMetadata.setAppLaunchUrl(new URL(appLaunchUrl));
            }
            catch (MalformedURLException e) {
                logger.info((Object)new ClientMetadataException("Invalid app-launch-url for client " + clientId, e, HttpStatus.INTERNAL_SERVER_ERROR));
            }
        }
        return clientMetadata;
    }

    protected boolean didPasswordChange(String clientId, String rawPassword) {
        if (this.getPasswordEncoder() != null) {
            ClientDetails existing = this.clientRegistrationService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
            String existingPasswordHash = existing.getClientSecret();
            return !this.getPasswordEncoder().matches((CharSequence)rawPassword, existingPasswordHash);
        }
        return true;
    }

    public ClientMetadataProvisioning getClientMetadataProvisioning() {
        return this.clientMetadataProvisioning;
    }

    public void setClientMetadataProvisioning(ClientMetadataProvisioning clientMetadataProvisioning) {
        this.clientMetadataProvisioning = clientMetadataProvisioning;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        SystemAuthentication auth = SystemAuthentication.SYSTEM_AUTHENTICATION;
        for (String clientId : Optional.ofNullable(this.clientsToDelete).orElse(Collections.emptyList())) {
            try {
                ClientDetails client = this.clientRegistrationService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
                logger.debug((Object)("Deleting client from manifest:" + clientId));
                EntityDeletedEvent<ClientDetails> delete = new EntityDeletedEvent<ClientDetails>(client, (Authentication)auth);
                this.publish(delete);
            }
            catch (NoSuchClientException e) {
                logger.debug((Object)("Ignoring delete for non existent client:" + clientId));
            }
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

