/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.login.AutologinRequest;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.util.LinkedMaskingMultiValueMap;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;

public class AutologinRequestConverter
extends AbstractHttpMessageConverter<AutologinRequest> {
    private FormHttpMessageConverter formConverter = new FormHttpMessageConverter();
    private StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();

    public AutologinRequestConverter() {
        this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON));
    }

    protected boolean supports(Class<?> clazz) {
        return AutologinRequest.class.isAssignableFrom(clazz);
    }

    public boolean isJsonContent(List<String> contentType) {
        if (contentType != null) {
            for (String s : contentType) {
                if (s == null || !s.contains("application/json")) continue;
                return true;
            }
        }
        return false;
    }

    protected AutologinRequest readInternal(Class<? extends AutologinRequest> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String password;
        String username;
        Object map;
        if (this.isJsonContent(inputMessage.getHeaders().get((Object)"Content-Type"))) {
            map = (Map)JsonUtils.readValue((String)((String)this.stringConverter.read(String.class, inputMessage)), (TypeReference)new TypeReference<Map<String, String>>(){});
            username = (String)map.get("username");
            password = (String)map.get("password");
        } else {
            map = this.formConverter.read(null, inputMessage);
            username = (String)map.getFirst((Object)"username");
            password = (String)map.getFirst((Object)"password");
        }
        AutologinRequest result = new AutologinRequest();
        result.setUsername(username);
        result.setPassword(password);
        return result;
    }

    protected void writeInternal(AutologinRequest t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        LinkedMaskingMultiValueMap map = new LinkedMaskingMultiValueMap("password");
        if (t.getUsername() != null) {
            map.set("username", t.getUsername());
        }
        if (t.getPassword() != null) {
            map.set("password", t.getPassword());
        }
        this.formConverter.write(map, MediaType.APPLICATION_FORM_URLENCODED, outputMessage);
    }
}

