/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit.event;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;

public class ApprovalModifiedEvent
extends AbstractUaaEvent {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ApprovalModifiedEvent(Object source, Authentication authentication) {
        super(source, authentication);
        if (!Approval.class.isAssignableFrom(source.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    public Approval getSource() {
        return (Approval)super.getSource();
    }

    @Override
    public AuditEvent getAuditEvent() {
        Approval source = this.getSource();
        return this.createAuditRecord(source.getUserId(), AuditEventType.ApprovalModifiedEvent, this.getOrigin((Principal)this.getAuthentication()), this.getData(source));
    }

    private String getData(Approval source) {
        try {
            return JsonUtils.writeValueAsString((Object)new ApprovalModifiedEventData(source));
        }
        catch (JsonUtils.JsonUtilException e) {
            this.logger.error((Object)"error writing approval event data", (Throwable)e);
            return null;
        }
    }

    private static class ApprovalModifiedEventData {
        private String scope;
        private Approval.ApprovalStatus status;

        public ApprovalModifiedEventData(Approval approval) {
            this.scope = approval.getScope();
            this.status = approval.getStatus();
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public Approval.ApprovalStatus getStatus() {
            return this.status;
        }

        public void setStatus(Approval.ApprovalStatus status) {
            this.status = status;
        }
    }
}

