/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.account.ChangePasswordService;
import org.cloudfoundry.identity.uaa.account.PasswordConfirmationValidation;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ChangePasswordController {
    private final ChangePasswordService changePasswordService;

    public ChangePasswordController(ChangePasswordService changePasswordService) {
        this.changePasswordService = changePasswordService;
    }

    @RequestMapping(value={"/change_password"}, method={RequestMethod.GET})
    public String changePasswordPage() {
        return "change_password";
    }

    @RequestMapping(value={"/change_password.do"}, method={RequestMethod.POST})
    public String changePassword(Model model, @RequestParam(value="current_password") String currentPassword, @RequestParam(value="new_password") String newPassword, @RequestParam(value="confirm_password") String confirmPassword, HttpServletResponse response, HttpServletRequest request) {
        PasswordConfirmationValidation validation = new PasswordConfirmationValidation(newPassword, confirmPassword);
        if (!validation.valid()) {
            model.addAttribute("message_code", (Object)validation.getMessageCode());
            response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
            return "change_password";
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        String username = authentication.getName();
        try {
            this.changePasswordService.changePassword(username, currentPassword, newPassword);
            request.getSession().invalidate();
            request.getSession(true);
            if (authentication instanceof UaaAuthentication) {
                UaaAuthentication uaaAuthentication = (UaaAuthentication)authentication;
                uaaAuthentication.setAuthenticatedTime(System.currentTimeMillis());
                uaaAuthentication.setAuthenticationDetails(new UaaAuthenticationDetails(request));
            }
            securityContext.setAuthentication(authentication);
            return "redirect:profile";
        }
        catch (BadCredentialsException e) {
            model.addAttribute("message_code", (Object)"unauthorized");
        }
        catch (InvalidPasswordException e) {
            model.addAttribute("message", (Object)e.getMessagesAsOneString());
        }
        response.setStatus(HttpStatus.UNPROCESSABLE_ENTITY.value());
        return "change_password";
    }
}

