/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.saml.SamlKey;
import org.springframework.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SamlConfig {
    public static final String LEGACY_KEY_ID = "legacy-saml-key";
    private boolean assertionSigned = true;
    private boolean requestSigned = true;
    private boolean wantAssertionSigned = true;
    private boolean wantAuthnRequestSigned = false;
    private int assertionTimeToLiveSeconds = 600;
    private String activeKeyId;
    private Map<String, SamlKey> keys = new HashMap<String, SamlKey>();
    private String entityID;
    private boolean disableInResponseToCheck = false;

    public boolean isAssertionSigned() {
        return this.assertionSigned;
    }

    public void setAssertionSigned(boolean assertionSigned) {
        this.assertionSigned = assertionSigned;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEntityID() {
        return this.entityID;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public boolean isRequestSigned() {
        return this.requestSigned;
    }

    public void setRequestSigned(boolean requestSigned) {
        this.requestSigned = requestSigned;
    }

    public boolean isWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    public void setWantAssertionSigned(boolean wantAssertionSigned) {
        this.wantAssertionSigned = wantAssertionSigned;
    }

    @JsonProperty(value="certificate")
    public void setCertificate(String certificate) {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (StringUtils.hasText((String)certificate) && null == legacyKey) {
            legacyKey = new SamlKey();
        }
        if (legacyKey != null) {
            legacyKey.setCertificate(certificate);
            this.keys.put(LEGACY_KEY_ID, legacyKey);
        }
    }

    @JsonProperty(value="privateKey")
    public void setPrivateKey(String privateKey) {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (StringUtils.hasText((String)privateKey) && null == legacyKey) {
            legacyKey = new SamlKey();
        }
        if (legacyKey != null) {
            legacyKey.setKey(privateKey);
            this.keys.put(LEGACY_KEY_ID, legacyKey);
        }
    }

    @JsonProperty(value="privateKeyPassword")
    public void setPrivateKeyPassword(String privateKeyPassword) {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (StringUtils.hasText((String)privateKeyPassword) && null == legacyKey) {
            legacyKey = new SamlKey();
        }
        if (legacyKey != null) {
            legacyKey.setPassphrase(privateKeyPassword);
            this.keys.put(LEGACY_KEY_ID, legacyKey);
        }
    }

    public boolean isWantAuthnRequestSigned() {
        return this.wantAuthnRequestSigned;
    }

    public void setWantAuthnRequestSigned(boolean wantAuthnRequestSigned) {
        this.wantAuthnRequestSigned = wantAuthnRequestSigned;
    }

    public int getAssertionTimeToLiveSeconds() {
        return this.assertionTimeToLiveSeconds;
    }

    public void setAssertionTimeToLiveSeconds(int assertionTimeToLiveSeconds) {
        this.assertionTimeToLiveSeconds = assertionTimeToLiveSeconds;
    }

    @JsonProperty(value="certificate")
    public String getCertificate() {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (null != legacyKey) {
            return legacyKey.getCertificate();
        }
        return null;
    }

    @JsonProperty
    public String getPrivateKey() {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (null != legacyKey) {
            return legacyKey.getKey();
        }
        return null;
    }

    @JsonProperty
    public String getPrivateKeyPassword() {
        SamlKey legacyKey = this.keys.get(LEGACY_KEY_ID);
        if (null != legacyKey) {
            return legacyKey.getPassphrase();
        }
        return null;
    }

    public String getActiveKeyId() {
        return StringUtils.hasText((String)this.activeKeyId) ? this.activeKeyId : (this.hasLegacyKey() ? LEGACY_KEY_ID : null);
    }

    public void setActiveKeyId(String activeKeyId) {
        if (!LEGACY_KEY_ID.equals(activeKeyId)) {
            this.activeKeyId = activeKeyId;
        }
    }

    public Map<String, SamlKey> getKeys() {
        return Collections.unmodifiableMap(this.keys);
    }

    public void setKeys(Map<String, SamlKey> keys) {
        this.keys = new HashMap<String, SamlKey>(keys);
    }

    @JsonIgnore
    public void addAndActivateKey(String keyId, SamlKey key) {
        this.addKey(keyId, key);
        this.activeKeyId = keyId;
    }

    @JsonIgnore
    public void addKey(String keyId, SamlKey key) {
        this.keys.put(keyId, key);
    }

    @JsonIgnore
    protected boolean hasLegacyKey() {
        return this.keys.get(LEGACY_KEY_ID) != null;
    }

    @JsonIgnore
    public SamlKey removeKey(String keyId) {
        return this.keys.remove(keyId);
    }

    public boolean isDisableInResponseToCheck() {
        return this.disableInResponseToCheck;
    }

    public void setDisableInResponseToCheck(boolean disableInResponseToCheck) {
        this.disableInResponseToCheck = disableInResponseToCheck;
    }
}

