/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MfaConfig {
    private boolean enabled = false;
    private String providerName;
    private List<String> identityProviders = new ArrayList<String>();
    private List<String> DEFAULT_MFA_IDENTITY_PROVIDERS = Arrays.asList("uaa", "ldap");

    public String toString() {
        return "MfaConfig: {enabled:" + this.enabled + ", providerName:\"" + this.providerName + '\"' + ", identityProviders:" + Arrays.toString(this.identityProviders.stream().toArray()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MfaConfig that = (MfaConfig)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return this.providerName != null ? this.providerName.equals(that.providerName) : that.providerName == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.providerName != null ? this.providerName.hashCode() : 0);
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MfaConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public MfaConfig setProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public List<String> getIdentityProviders() {
        if (this.identityProviders == null || this.identityProviders.isEmpty()) {
            return this.DEFAULT_MFA_IDENTITY_PROVIDERS;
        }
        return this.identityProviders;
    }

    public void setIdentityProviders(List<String> identityProviders) {
        this.identityProviders = identityProviders;
    }
}

