/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ScimGroup
extends ScimCore<ScimGroup> {
    private String displayName;
    private String zoneId;
    private String description;
    private List<ScimGroupMember> members;

    public String getDisplayName() {
        return this.displayName;
    }

    public ScimGroup setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public ScimGroup setZoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public List<ScimGroupMember> getMembers() {
        return this.members;
    }

    public ScimGroup setMembers(List<ScimGroupMember> members) {
        this.members = members;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScimGroup() {
        this(null);
    }

    public ScimGroup(String name) {
        this(null, name, null);
    }

    public ScimGroup(String id, String displayName, String zoneId) {
        super(id);
        this.displayName = displayName;
        this.zoneId = zoneId;
    }

    @Override
    public void patch(ScimGroup patch) {
        String[] attributes;
        block14: for (String attribute : attributes = Optional.ofNullable(patch.getMeta().getAttributes()).orElse(new String[0])) {
            switch (attribute.toUpperCase()) {
                case "DESCRIPTION": {
                    this.setDescription(null);
                    continue block14;
                }
                case "DISPLAYNAME": {
                    this.setDisplayName(null);
                    continue block14;
                }
                case "ZONEID": {
                    throw new IllegalArgumentException("Cannot delete or change ZoneId");
                }
                case "ID": {
                    throw new IllegalArgumentException("Cannot delete or change ID");
                }
                case "MEMBERS": {
                    this.setMembers(new ArrayList<ScimGroupMember>());
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Attribute %s cannot be removed using \"Meta.attributes\"", attribute));
                }
            }
        }
        if (patch.getMembers() != null) {
            Set patchMemberIds = patch.getMembers().stream().map(member -> member.getMemberId()).collect(Collectors.toSet());
            ArrayList<ScimGroupMember> newMembers = new ArrayList<ScimGroupMember>(this.getMembers());
            newMembers.removeIf(member -> patchMemberIds.contains(member.getMemberId()));
            newMembers.addAll(patch.getMembers().stream().filter(member -> !"delete".equalsIgnoreCase(member.getOperation())).collect(Collectors.toList()));
            this.setMembers(newMembers);
        }
        Optional.ofNullable(patch.getDescription()).ifPresent(d -> this.setDescription((String)d));
        Optional.ofNullable(patch.getDisplayName()).ifPresent(d -> this.setDisplayName((String)d));
    }

    public String toString() {
        return String.format("(Group id: %s, name: %s, description: %s, created: %s, modified: %s, version: %s, members: %s)", this.getId(), this.displayName, this.description, this.getMeta().getCreated(), this.getMeta().getLastModified(), this.getVersion(), this.members);
    }
}

