/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import java.util.Date;
import org.cloudfoundry.identity.uaa.authentication.GenericPasswordPolicy;

public class PasswordPolicy
extends GenericPasswordPolicy<PasswordPolicy> {
    public static final String PASSWORD_POLICY_FIELD = "passwordPolicy";
    private Date passwordNewerThan;
    private int expirePasswordInMonths;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.expirePasswordInMonths;
        result = 31 * result + (this.passwordNewerThan == null ? 0 : this.passwordNewerThan.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordPolicy that = (PasswordPolicy)obj;
        return super.equals(obj) && this.expirePasswordInMonths == that.expirePasswordInMonths;
    }

    public PasswordPolicy() {
        this.expirePasswordInMonths = -1;
    }

    public PasswordPolicy(int minLength, int maxLength, int requireUpperCaseCharacter, int requireLowerCaseCharacter, int requireDigit, int requireSpecialCharacter, int expirePasswordInMonths) {
        super(minLength, maxLength, requireUpperCaseCharacter, requireLowerCaseCharacter, requireDigit, requireSpecialCharacter);
        this.setExpirePasswordInMonths(expirePasswordInMonths);
    }

    public Date getPasswordNewerThan() {
        return this.passwordNewerThan;
    }

    public void setPasswordNewerThan(Date passwordNewerThan) {
        this.passwordNewerThan = passwordNewerThan;
    }

    public int getExpirePasswordInMonths() {
        return this.expirePasswordInMonths;
    }

    public PasswordPolicy setExpirePasswordInMonths(int expirePasswordInMonths) {
        this.expirePasswordInMonths = expirePasswordInMonths;
        return this;
    }

    @Override
    public boolean allPresentAndPositive() {
        return super.allPresentAndPositive() && this.expirePasswordInMonths >= 0;
    }
}

