/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.KeystoneIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.LdapIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.RawXOAuthIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.SamlIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.StringUtils;

@JsonSerialize(using=IdentityProviderSerializer.class)
@JsonDeserialize(using=IdentityProviderDeserializer.class)
public class IdentityProvider<T extends AbstractIdentityProviderDefinition> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_ORIGIN_KEY = "originKey";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_LAST_MODIFIED = "last_modified";
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_IDENTITY_ZONE_ID = "identityZoneId";
    public static final String FIELD_CONFIG = "config";
    public static final String FIELD_TYPE = "type";
    private String id;
    @NotNull
    private String originKey;
    @NotNull
    private String name;
    @NotNull
    private String type;
    private T config;
    private int version = 0;
    private Date created = new Date();
    @JsonProperty(value="last_modified")
    private Date lastModified = new Date();
    private boolean active = true;
    private String identityZoneId;
    private boolean serializeConfigRaw;

    public Date getCreated() {
        return this.created;
    }

    public IdentityProvider setCreated(Date created) {
        this.created = created;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public IdentityProvider setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public IdentityProvider setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public IdentityProvider setName(String name) {
        this.name = name;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public IdentityProvider setId(String id) {
        this.id = id;
        return this;
    }

    public T getConfig() {
        return this.config;
    }

    public IdentityProvider setConfig(T config) {
        if (config == null) {
            this.type = "unknown";
        } else {
            Class<?> clazz = config.getClass();
            if (SamlIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "saml";
                if (StringUtils.hasText((String)this.getOriginKey())) {
                    ((SamlIdentityProviderDefinition)config).setIdpEntityAlias(this.getOriginKey());
                }
                if (StringUtils.hasText((String)this.getIdentityZoneId())) {
                    ((SamlIdentityProviderDefinition)config).setZoneId(this.getIdentityZoneId());
                }
            } else if (UaaIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "uaa";
            } else if (RawXOAuthIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "oauth2.0";
            } else if (OIDCIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "oidc1.0";
            } else if (LdapIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "ldap";
            } else if (KeystoneIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "keystone";
            } else if (AbstractIdentityProviderDefinition.class.isAssignableFrom(clazz)) {
                this.type = "unknown";
            } else {
                throw new IllegalArgumentException("Unknown identity provider configuration type:" + clazz.getName());
            }
        }
        this.config = config;
        return this;
    }

    public String getOriginKey() {
        return this.originKey;
    }

    public IdentityProvider setOriginKey(String originKey) {
        this.originKey = originKey;
        if (this.config != null && this.config instanceof SamlIdentityProviderDefinition) {
            ((SamlIdentityProviderDefinition)this.config).setIdpEntityAlias(originKey);
        }
        return this;
    }

    public String getType() {
        return this.type;
    }

    public IdentityProvider setType(String type) {
        this.type = type;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public IdentityProvider setActive(boolean active) {
        this.active = active;
        return this;
    }

    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public IdentityProvider setIdentityZoneId(String identityZoneId) {
        this.identityZoneId = identityZoneId;
        if (this.config != null && this.config instanceof SamlIdentityProviderDefinition) {
            ((SamlIdentityProviderDefinition)this.config).setZoneId(identityZoneId);
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : ((AbstractIdentityProviderDefinition)this.config).hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originKey == null ? 0 : this.originKey.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityProvider other = (IdentityProvider)obj;
        if (this.config == null ? other.config != null : !((AbstractIdentityProviderDefinition)this.config).equals(other.config)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.originKey == null ? other.originKey != null : !this.originKey.equals(other.originKey)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IdentityProvider{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", originKey='").append(this.originKey).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", active=").append(this.active);
        sb.append('}');
        return sb.toString();
    }

    @JsonIgnore
    public boolean isSerializeConfigRaw() {
        return this.serializeConfigRaw;
    }

    @JsonIgnore
    public void setSerializeConfigRaw(boolean serializeConfigRaw) {
        this.serializeConfigRaw = serializeConfigRaw;
    }

    public static class IdentityProviderDeserializer
    extends JsonDeserializer<IdentityProvider> {
        public IdentityProvider deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            IdentityProvider<AbstractIdentityProviderDefinition> result = new IdentityProvider<AbstractIdentityProviderDefinition>();
            JsonNode node = JsonUtils.readTree((JsonParser)jp);
            String type = JsonUtils.getNodeAsString((JsonNode)node, (String)IdentityProvider.FIELD_TYPE, (String)"unknown");
            JsonNode configNode = node.get(IdentityProvider.FIELD_CONFIG);
            String config = configNode == null ? null : (configNode.isTextual() ? configNode.textValue() : configNode.toString());
            AbstractIdentityProviderDefinition definition = null;
            if (StringUtils.hasText((String)config)) {
                switch (type) {
                    case "saml": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, SamlIdentityProviderDefinition.class);
                        break;
                    }
                    case "oauth2.0": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, RawXOAuthIdentityProviderDefinition.class);
                        break;
                    }
                    case "oidc1.0": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, OIDCIdentityProviderDefinition.class);
                        break;
                    }
                    case "uaa": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, UaaIdentityProviderDefinition.class);
                        break;
                    }
                    case "ldap": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, LdapIdentityProviderDefinition.class);
                        break;
                    }
                    case "keystone": {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, KeystoneIdentityProviderDefinition.class);
                        break;
                    }
                    default: {
                        definition = (AbstractIdentityProviderDefinition)JsonUtils.readValue((String)config, AbstractIdentityProviderDefinition.class);
                    }
                }
            }
            result.setConfig(definition);
            result.setType(type);
            result.setId(JsonUtils.getNodeAsString((JsonNode)node, (String)IdentityProvider.FIELD_ID, null));
            result.setOriginKey(JsonUtils.getNodeAsString((JsonNode)node, (String)IdentityProvider.FIELD_ORIGIN_KEY, null));
            result.setName(JsonUtils.getNodeAsString((JsonNode)node, (String)IdentityProvider.FIELD_NAME, null));
            result.setVersion(JsonUtils.getNodeAsInt((JsonNode)node, (String)IdentityProvider.FIELD_VERSION, (int)0));
            result.setCreated(JsonUtils.getNodeAsDate((JsonNode)node, (String)IdentityProvider.FIELD_CREATED));
            result.setLastModified(JsonUtils.getNodeAsDate((JsonNode)node, (String)IdentityProvider.FIELD_LAST_MODIFIED));
            result.setActive(JsonUtils.getNodeAsBoolean((JsonNode)node, (String)IdentityProvider.FIELD_ACTIVE, (boolean)true));
            result.setIdentityZoneId(JsonUtils.getNodeAsString((JsonNode)node, (String)IdentityProvider.FIELD_IDENTITY_ZONE_ID, null));
            return result;
        }
    }

    public static class IdentityProviderSerializer
    extends JsonSerializer<IdentityProvider> {
        public void serialize(IdentityProvider value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeStringField(IdentityProvider.FIELD_TYPE, value.getType());
            if (value.isSerializeConfigRaw()) {
                gen.writeObjectField(IdentityProvider.FIELD_CONFIG, value.getConfig());
            } else {
                gen.writeStringField(IdentityProvider.FIELD_CONFIG, JsonUtils.writeValueAsString(value.getConfig()));
            }
            gen.writeStringField(IdentityProvider.FIELD_ID, value.getId());
            gen.writeStringField(IdentityProvider.FIELD_ORIGIN_KEY, value.getOriginKey());
            gen.writeStringField(IdentityProvider.FIELD_NAME, value.getName());
            gen.writeNumberField(IdentityProvider.FIELD_VERSION, value.getVersion());
            this.writeDateField(IdentityProvider.FIELD_CREATED, value.getCreated(), gen);
            this.writeDateField(IdentityProvider.FIELD_LAST_MODIFIED, value.getLastModified(), gen);
            gen.writeBooleanField(IdentityProvider.FIELD_ACTIVE, value.isActive());
            gen.writeStringField(IdentityProvider.FIELD_IDENTITY_ZONE_ID, value.getIdentityZoneId());
            gen.writeEndObject();
        }

        public void writeDateField(String fieldName, Date value, JsonGenerator gen) throws IOException {
            if (value != null) {
                gen.writeNumberField(fieldName, value.getTime());
            } else {
                gen.writeNullField(fieldName);
            }
        }
    }
}

