/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.AbstractIdentityProviderDefinition;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalIdentityProviderDefinition
extends AbstractIdentityProviderDefinition {
    public static final String GROUP_ATTRIBUTE_NAME = "external_groups";
    public static final String EMAIL_ATTRIBUTE_NAME = "email";
    public static final String GIVEN_NAME_ATTRIBUTE_NAME = "given_name";
    public static final String FAMILY_NAME_ATTRIBUTE_NAME = "family_name";
    public static final String PHONE_NUMBER_ATTRIBUTE_NAME = "phone_number";
    public static final String EMAIL_VERIFIED_ATTRIBUTE_NAME = "email_verified";
    public static final String USER_ATTRIBUTE_PREFIX = "user.attribute.";
    public static final String USER_NAME_ATTRIBUTE_NAME = "user_name";
    public static final String STORE_CUSTOM_ATTRIBUTES_NAME = "storeCustomAttributes";
    public static final String EXTERNAL_GROUPS_WHITELIST = "externalGroupsWhitelist";
    public static final String ATTRIBUTE_MAPPINGS = "attributeMappings";
    private List<String> externalGroupsWhitelist = new LinkedList<String>();
    private Map<String, Object> attributeMappings = new HashMap<String, Object>();
    private boolean addShadowUserOnLogin = true;
    private boolean storeCustomAttributes = true;

    public List<String> getExternalGroupsWhitelist() {
        return Collections.unmodifiableList(this.externalGroupsWhitelist);
    }

    public void setExternalGroupsWhitelist(List<String> externalGroupsWhitelist) {
        this.externalGroupsWhitelist = new LinkedList<String>(externalGroupsWhitelist != null ? externalGroupsWhitelist : Collections.emptyList());
    }

    @JsonIgnore
    public void addWhiteListedGroup(String group) {
        this.externalGroupsWhitelist.add(group);
    }

    public void setAttributeMappings(Map<String, Object> attributeMappings) {
        this.attributeMappings = new HashMap<String, Object>(attributeMappings != null ? attributeMappings : Collections.emptyMap());
    }

    public Map<String, Object> getAttributeMappings() {
        return Collections.unmodifiableMap(this.attributeMappings);
    }

    @JsonIgnore
    public void addAttributeMapping(String key, Object value) {
        this.attributeMappings.put(key, value);
    }

    public boolean isAddShadowUserOnLogin() {
        return this.addShadowUserOnLogin;
    }

    public void setAddShadowUserOnLogin(boolean addShadowUserOnLogin) {
        this.addShadowUserOnLogin = addShadowUserOnLogin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalIdentityProviderDefinition that = (ExternalIdentityProviderDefinition)o;
        if (this.addShadowUserOnLogin != that.addShadowUserOnLogin) {
            return false;
        }
        if (this.isStoreCustomAttributes() != that.isStoreCustomAttributes()) {
            return false;
        }
        if (this.getExternalGroupsWhitelist() != null ? !this.getExternalGroupsWhitelist().equals(that.getExternalGroupsWhitelist()) : that.getExternalGroupsWhitelist() != null) {
            return false;
        }
        return this.attributeMappings != null ? this.attributeMappings.equals(that.attributeMappings) : that.attributeMappings == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalGroupsWhitelist != null ? this.externalGroupsWhitelist.hashCode() : 0);
        result = 31 * result + (this.attributeMappings != null ? this.attributeMappings.hashCode() : 0);
        result = 31 * result + (this.addShadowUserOnLogin ? 1 : 0);
        return result;
    }

    public boolean isStoreCustomAttributes() {
        return this.storeCustomAttributes;
    }

    public void setStoreCustomAttributes(boolean storeCustomAttributes) {
        this.storeCustomAttributes = storeCustomAttributes;
    }
}

