/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.jwk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeyDeserializer;
import org.cloudfoundry.identity.uaa.oauth.jwk.JsonWebKeySerializer;
import org.springframework.util.StringUtils;

@JsonDeserialize(using=JsonWebKeyDeserializer.class)
@JsonSerialize(using=JsonWebKeySerializer.class)
public class JsonWebKey {
    public static String KID = "kid";
    public static String KTY = "kty";
    public static String ALG = "alg";
    private final Map<String, Object> json;

    public JsonWebKey(Map<String, Object> json) {
        if (json.get("kty") == null) {
            throw new IllegalArgumentException("kty field is required");
        }
        KeyType.valueOf((String)json.get("kty"));
        this.json = new HashMap<String, Object>(json);
    }

    public Map<String, Object> getKeyProperties() {
        return Collections.unmodifiableMap(this.json);
    }

    public final KeyType getKty() {
        return KeyType.valueOf((String)this.getKeyProperties().get(KTY));
    }

    public final String getKid() {
        return (String)this.getKeyProperties().get(KID);
    }

    public JsonWebKey setKid(String kid) {
        this.json.put(KID, kid);
        return this;
    }

    public final KeyUse getUse() {
        String use = (String)this.getKeyProperties().get("use");
        KeyUse result = null;
        if (StringUtils.hasText((String)use)) {
            result = KeyUse.valueOf(use);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonWebKey)) {
            return false;
        }
        JsonWebKey that = (JsonWebKey)o;
        return this.getKid() != null ? this.getKid().equals(that.getKid()) : that.getKid() == null && this.getKeyProperties().equals(that.getKeyProperties());
    }

    public int hashCode() {
        if (this.getKid() == null) {
            return this.getKty().hashCode();
        }
        return this.getKid().hashCode();
    }

    public String getAlgorithm() {
        return (String)this.getKeyProperties().get(ALG);
    }

    public String getValue() {
        String result = (String)this.getKeyProperties().get("value");
        if (result == null) {
            if (KeyType.RSA.equals((Object)this.getKty())) {
                result = JsonWebKey.pemEncodePublicKey(JsonWebKey.getRsaPublicKey(this));
                this.json.put("value", result);
            } else if (KeyType.MAC.equals((Object)this.getKty())) {
                result = (String)this.getKeyProperties().get("k");
                this.json.put("value", result);
            }
        }
        return result;
    }

    public Set<KeyOperation> getKeyOps() {
        List result = (List)this.getKeyProperties().get("key_ops");
        if (result == null) {
            result = Collections.emptyList();
        }
        return result.stream().map(o -> KeyOperation.valueOf(o)).collect(Collectors.toSet());
    }

    public static String pemEncodePublicKey(PublicKey publicKey) {
        String begin = "-----BEGIN PUBLIC KEY-----\n";
        String end = "\n-----END PUBLIC KEY-----";
        byte[] data = publicKey.getEncoded();
        String base64encoded = new String(new Base64(false).encode(data));
        return begin + base64encoded + end;
    }

    public static PublicKey getRsaPublicKey(JsonWebKey key) {
        Base64 decoder = new Base64(true);
        String e = (String)key.getKeyProperties().get("e");
        String n = (String)key.getKeyProperties().get("n");
        BigInteger modulus = new BigInteger(1, decoder.decode(n.getBytes(StandardCharsets.UTF_8)));
        BigInteger exponent = new BigInteger(1, decoder.decode(e.getBytes(StandardCharsets.UTF_8)));
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e1) {
            throw new IllegalStateException(e1);
        }
    }

    public static enum KeyOperation {
        sign,
        verify,
        encrypt,
        decrypt,
        wrapKey,
        unwrapKey,
        deriveKey,
        deriveBits;

    }

    public static enum KeyType {
        RSA,
        MAC;

    }

    public static enum KeyUse {
        sig,
        enc;

    }
}

