/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.util;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Function;
import org.atteo.evo.inflector.English;
import org.cloudfoundry.util.DelayTimeoutException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DelayUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.delay");

    private DelayUtils() {
    }

    public static Function<Flux<Long>, Publisher<?>> exponentialBackOff(Duration minimum, Duration maximum, Duration timeout) {
        Instant finish = Instant.now().plus(timeout);
        return iterations -> DelayUtils.getDelay(minimum, maximum, finish, (Flux<Long>)iterations);
    }

    public static Function<Flux<Throwable>, Publisher<?>> exponentialBackOffError(Duration minimum, Duration maximum, Duration timeout) {
        Instant finish = Instant.now().plus(timeout);
        return errors -> DelayUtils.getDelay(minimum, maximum, finish, (Flux<Long>)errors.zipWith((Publisher)Flux.range((int)0, (int)Integer.MAX_VALUE), (error, iteration) -> iteration.longValue()));
    }

    public static Function<Flux<Long>, Publisher<?>> fixed(Duration duration) {
        return iterations -> iterations.flatMap(iteration -> Mono.delay((Duration)duration).doOnSubscribe(DelayUtils.logDelay(duration)), 1);
    }

    public static Function<Flux<Long>, Publisher<?>> instant() {
        return iterations -> iterations.flatMap(iteration -> Mono.just((Object)0L).doOnSubscribe(DelayUtils.logDelay(Duration.ZERO)), 1);
    }

    private static Duration calculateDuration(Duration minimum, Duration maximum, Long iteration) {
        Duration candidate = minimum.multipliedBy((long)Math.pow(2.0, iteration.longValue()));
        return DelayUtils.min(candidate, maximum);
    }

    private static Flux<?> getDelay(Duration minimum, Duration maximum, Instant finish, Flux<Long> iterations) {
        return iterations.map(iteration -> DelayUtils.calculateDuration(minimum, maximum, iteration)).concatMap(delay -> {
            if (Instant.now().isAfter(finish)) {
                return Mono.error((Throwable)new DelayTimeoutException());
            }
            return Mono.delay((Duration)delay).doOnSubscribe(DelayUtils.logDelay(delay));
        });
    }

    private static Consumer<Subscription> logDelay(Duration delay) {
        return subscription -> {
            int seconds = (int)delay.getSeconds();
            if (seconds > 0) {
                LOGGER.debug("Delaying {} {}", (Object)seconds, (Object)English.plural((String)"second", (int)seconds));
                return;
            }
            int milliseconds = (int)delay.toMillis();
            LOGGER.debug("Delaying {} {}", (Object)milliseconds, (Object)English.plural((String)"millisecond", (int)milliseconds));
        };
    }

    private static Duration min(Duration a, Duration b) {
        return a.compareTo(b) <= 0 ? a : b;
    }
}

