/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.routes._UnmapRouteRequest;
import org.immutables.value.Generated;

@Generated(from="_UnmapRouteRequest", generator="Immutables")
public final class UnmapRouteRequest
extends _UnmapRouteRequest {
    private final String applicationName;
    private final String domain;
    @Nullable
    private final String host;
    @Nullable
    private final String path;
    @Nullable
    private final Integer port;

    private UnmapRouteRequest(Builder builder) {
        this.applicationName = builder.applicationName;
        this.domain = builder.domain;
        this.host = builder.host;
        this.path = builder.path;
        this.port = builder.port;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnmapRouteRequest && this.equalTo((UnmapRouteRequest)another);
    }

    private boolean equalTo(UnmapRouteRequest another) {
        return this.applicationName.equals(another.applicationName) && this.domain.equals(another.domain) && Objects.equals(this.host, another.host) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationName.hashCode();
        h += (h << 5) + this.domain.hashCode();
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        return h;
    }

    public String toString() {
        return "UnmapRouteRequest{applicationName=" + this.applicationName + ", domain=" + this.domain + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + "}";
    }

    private static UnmapRouteRequest validate(UnmapRouteRequest instance) {
        instance.checkSetup();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_UnmapRouteRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_NAME = 1L;
        private static final long INIT_BIT_DOMAIN = 2L;
        private long initBits = 3L;
        private String applicationName;
        private String domain;
        private String host;
        private String path;
        private Integer port;

        private Builder() {
        }

        public final Builder from(UnmapRouteRequest instance) {
            return this.from((_UnmapRouteRequest)instance);
        }

        final Builder from(_UnmapRouteRequest instance) {
            Integer portValue;
            String pathValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationName(instance.getApplicationName());
            this.domain(instance.getDomain());
            String hostValue = instance.getHost();
            if (hostValue != null) {
                this.host(hostValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((portValue = instance.getPort()) != null) {
                this.port(portValue);
            }
            return this;
        }

        public final Builder applicationName(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public UnmapRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return UnmapRouteRequest.validate(new UnmapRouteRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("domain");
            }
            return "Cannot build UnmapRouteRequest, some of required attributes are not set " + attributes;
        }
    }
}

