/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.spaces._CreateSpaceRequest;

public final class CreateSpaceRequest
extends _CreateSpaceRequest {
    private final String name;
    @Nullable
    private final String organization;
    @Nullable
    private final String spaceQuota;

    private CreateSpaceRequest(Builder builder) {
        this.name = builder.name;
        this.organization = builder.organization;
        this.spaceQuota = builder.spaceQuota;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Override
    @Nullable
    public String getSpaceQuota() {
        return this.spaceQuota;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSpaceRequest && this.equalTo((CreateSpaceRequest)another);
    }

    private boolean equalTo(CreateSpaceRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.organization, another.organization) && Objects.equals(this.spaceQuota, another.spaceQuota);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.organization);
        h += (h << 5) + Objects.hashCode(this.spaceQuota);
        return h;
    }

    public String toString() {
        return "CreateSpaceRequest{name=" + this.name + ", organization=" + this.organization + ", spaceQuota=" + this.spaceQuota + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String organization;
        private String spaceQuota;

        private Builder() {
        }

        public final Builder from(CreateSpaceRequest instance) {
            return this.from((_CreateSpaceRequest)instance);
        }

        final Builder from(_CreateSpaceRequest instance) {
            String spaceQuotaValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String organizationValue = instance.getOrganization();
            if (organizationValue != null) {
                this.organization(organizationValue);
            }
            if ((spaceQuotaValue = instance.getSpaceQuota()) != null) {
                this.spaceQuota(spaceQuotaValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public final Builder spaceQuota(@Nullable String spaceQuota) {
            this.spaceQuota = spaceQuota;
            return this;
        }

        public CreateSpaceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSpaceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
        }
    }
}

