/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.buildpacks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.buildpacks._UpdateBuildpackRequest;

public final class UpdateBuildpackRequest
extends _UpdateBuildpackRequest {
    @Nullable
    private final Path buildpack;
    @Nullable
    private final Boolean enable;
    @Nullable
    private final Boolean lock;
    private final String name;
    @Nullable
    private final Integer position;

    private UpdateBuildpackRequest(Builder builder) {
        this.buildpack = builder.buildpack;
        this.enable = builder.enable;
        this.lock = builder.lock;
        this.name = builder.name;
        this.position = builder.position;
    }

    @Override
    @Nullable
    public Path getBuildpack() {
        return this.buildpack;
    }

    @Override
    @Nullable
    public Boolean getEnable() {
        return this.enable;
    }

    @Override
    @Nullable
    public Boolean getLock() {
        return this.lock;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Integer getPosition() {
        return this.position;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateBuildpackRequest && this.equalTo((UpdateBuildpackRequest)another);
    }

    private boolean equalTo(UpdateBuildpackRequest another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.enable, another.enable) && Objects.equals(this.lock, another.lock) && this.name.equals(another.name) && Objects.equals(this.position, another.position);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + Objects.hashCode(this.enable);
        h += (h << 5) + Objects.hashCode(this.lock);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.position);
        return h;
    }

    public String toString() {
        return "UpdateBuildpackRequest{buildpack=" + this.buildpack + ", enable=" + this.enable + ", lock=" + this.lock + ", name=" + this.name + ", position=" + this.position + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Path buildpack;
        private Boolean enable;
        private Boolean lock;
        private String name;
        private Integer position;

        private Builder() {
        }

        public final Builder from(UpdateBuildpackRequest instance) {
            return this.from((_UpdateBuildpackRequest)instance);
        }

        final Builder from(_UpdateBuildpackRequest instance) {
            Boolean lockValue;
            Boolean enableValue;
            Objects.requireNonNull(instance, "instance");
            Path buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((enableValue = instance.getEnable()) != null) {
                this.enable(enableValue);
            }
            if ((lockValue = instance.getLock()) != null) {
                this.lock(lockValue);
            }
            this.name(instance.getName());
            Integer positionValue = instance.getPosition();
            if (positionValue != null) {
                this.position(positionValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable Path buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder enable(@Nullable Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final Builder lock(@Nullable Boolean lock) {
            this.lock = lock;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder position(@Nullable Integer position) {
            this.position = position;
            return this;
        }

        public UpdateBuildpackRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateBuildpackRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build UpdateBuildpackRequest, some of required attributes are not set " + attributes;
        }
    }
}

