/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.routes;

import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v2.routes.AssociateRouteApplicationRequest;
import org.cloudfoundry.client.v2.routes.AssociateRouteApplicationResponse;
import org.cloudfoundry.client.v2.routes.CreateRouteRequest;
import org.cloudfoundry.client.v2.routes.CreateRouteResponse;
import org.cloudfoundry.client.v2.routes.DeleteRouteRequest;
import org.cloudfoundry.client.v2.routes.DeleteRouteResponse;
import org.cloudfoundry.client.v2.routes.GetRouteRequest;
import org.cloudfoundry.client.v2.routes.GetRouteResponse;
import org.cloudfoundry.client.v2.routes.ListRouteApplicationsRequest;
import org.cloudfoundry.client.v2.routes.ListRouteApplicationsResponse;
import org.cloudfoundry.client.v2.routes.ListRouteMappingsRequest;
import org.cloudfoundry.client.v2.routes.ListRouteMappingsResponse;
import org.cloudfoundry.client.v2.routes.ListRoutesRequest;
import org.cloudfoundry.client.v2.routes.ListRoutesResponse;
import org.cloudfoundry.client.v2.routes.RemoveRouteApplicationRequest;
import org.cloudfoundry.client.v2.routes.RouteExistsRequest;
import org.cloudfoundry.client.v2.routes.Routes;
import org.cloudfoundry.client.v2.routes.UpdateRouteRequest;
import org.cloudfoundry.client.v2.routes.UpdateRouteResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.cloudfoundry.util.ExceptionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorRoutes
extends AbstractClientV2Operations
implements Routes {
    private static final int CF_NOT_FOUND = 10000;

    public ReactorRoutes(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<AssociateRouteApplicationResponse> associateApplication(AssociateRouteApplicationRequest request) {
        return this.put(request, AssociateRouteApplicationResponse.class, builder -> builder.pathSegment(new String[]{"routes", request.getRouteId(), "apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<CreateRouteResponse> create(CreateRouteRequest request) {
        return this.post(request, CreateRouteResponse.class, builder -> builder.pathSegment(new String[]{"routes"})).checkpoint();
    }

    public Mono<DeleteRouteResponse> delete(DeleteRouteRequest request) {
        return this.delete(request, DeleteRouteResponse.class, builder -> builder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }

    public Mono<Boolean> exists(RouteExistsRequest request) {
        return this.get((Object)request, Boolean.class, (UriComponentsBuilder builder) -> {
            builder.pathSegment(new String[]{"routes", "reserved", "domain", request.getDomainId()});
            Optional.ofNullable(request.getHost()).ifPresent(host -> builder.pathSegment(new String[]{"host", host}));
            return builder;
        }).defaultIfEmpty((Object)true).onErrorResume(ExceptionUtils.statusCode((int[])new int[]{10000}), t -> Mono.just((Object)false)).checkpoint();
    }

    public Mono<GetRouteResponse> get(GetRouteRequest request) {
        return this.get((Object)request, GetRouteResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }

    public Mono<ListRoutesResponse> list(ListRoutesRequest request) {
        return this.get((Object)request, ListRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"routes"})).checkpoint();
    }

    public Mono<ListRouteApplicationsResponse> listApplications(ListRouteApplicationsRequest request) {
        return this.get((Object)request, ListRouteApplicationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"routes", request.getRouteId(), "apps"})).checkpoint();
    }

    public Mono<ListRouteMappingsResponse> listMappings(ListRouteMappingsRequest request) {
        return this.get((Object)request, ListRouteMappingsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"routes", request.getRouteId(), "route_mappings"})).checkpoint();
    }

    public Mono<Void> removeApplication(RemoveRouteApplicationRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"routes", request.getRouteId(), "apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<UpdateRouteResponse> update(UpdateRouteRequest request) {
        return this.put(request, UpdateRouteResponse.class, builder -> builder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }
}

