/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.networking;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.networking.v1.policies.Policies;
import org.cloudfoundry.networking.v1.tags.Tags;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.networking._ReactorNetworkingClient;
import reactor.core.publisher.Mono;

public final class ReactorNetworkingClient
extends _ReactorNetworkingClient {
    private final Policies policies;
    private final Tags tags;
    private final ConnectionContext connectionContext;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorNetworkingClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.tokenProvider = builder.tokenProvider;
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        this.root = this.initShim.getRoot();
        this.policies = this.initShim.policies();
        this.tags = this.initShim.tags();
        this.initShim = null;
    }

    @Override
    public Policies policies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.policies() : this.policies;
    }

    @Override
    public Tags tags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tags() : this.tags;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorNetworkingClient && this.equalTo((ReactorNetworkingClient)another);
    }

    private boolean equalTo(ReactorNetworkingClient another) {
        return this.policies.equals(another.policies) && this.tags.equals(another.tags) && this.connectionContext.equals(another.connectionContext) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.policies.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorNetworkingClient{policies=" + this.policies + ", tags=" + this.tags + ", connectionContext=" + this.connectionContext + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private long initBits = 3L;
        private ConnectionContext connectionContext;
        private Mono<String> root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(ReactorNetworkingClient instance) {
            return this.from((_ReactorNetworkingClient)instance);
        }

        final Builder from(_ReactorNetworkingClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReactorNetworkingClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorNetworkingClient(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorNetworkingClient, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private Policies policies;
        private int policiesBuildStage;
        private Tags tags;
        private int tagsBuildStage;
        private Mono<String> root;
        private int rootBuildStage;

        private InitShim() {
        }

        Policies policies() {
            if (this.policiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.policiesBuildStage == 0) {
                this.policiesBuildStage = -1;
                this.policies = Objects.requireNonNull(ReactorNetworkingClient.super.policies(), "policies");
                this.policiesBuildStage = 1;
            }
            return this.policies;
        }

        Tags tags() {
            if (this.tagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsBuildStage == 0) {
                this.tagsBuildStage = -1;
                this.tags = Objects.requireNonNull(ReactorNetworkingClient.super.tags(), "tags");
                this.tagsBuildStage = 1;
            }
            return this.tags;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = -1;
                this.root = Objects.requireNonNull(ReactorNetworkingClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.policiesBuildStage == -1) {
                attributes.add("policies");
            }
            if (this.tagsBuildStage == -1) {
                attributes.add("tags");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            return "Cannot build ReactorNetworkingClient, attribute initializers form cycle" + attributes;
        }
    }
}

