/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;

final class FilterBuilder {
    private FilterBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Arrays.stream(instance.getClass().getMethods()).sorted(MethodNameComparator.INSTANCE).forEach(FilterBuilder.processMethod(builder, instance));
    }

    private static Optional<Object> getValue(Method method, Object instance) {
        try {
            return Optional.ofNullable(method.invoke(instance, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Consumer<FilterParameter> processAnnotation(UriComponentsBuilder builder, Method method, Object instance) {
        return filterParameter -> FilterBuilder.getValue(method, instance).ifPresent(FilterBuilder.processValue(builder, filterParameter));
    }

    private static void processCollection(UriComponentsBuilder builder, String name, Object value) {
        FilterBuilder.processValue(builder, name, ((Collection)value).stream().map(o -> o.toString().trim()).filter(s -> !s.isEmpty()).collect(Collectors.joining(",")));
    }

    private static Consumer<Method> processMethod(UriComponentsBuilder builder, Object instance) {
        return method -> AnnotationUtils.findAnnotation(method, FilterParameter.class).ifPresent(FilterBuilder.processAnnotation(builder, method, instance));
    }

    private static void processValue(UriComponentsBuilder builder, String name, String value) {
        if (!value.isEmpty()) {
            builder.queryParam(name, new Object[]{value});
        }
    }

    private static Consumer<Object> processValue(UriComponentsBuilder builder, FilterParameter filterParameter) {
        return value -> {
            if (value instanceof Collection) {
                FilterBuilder.processCollection(builder, filterParameter.value(), value);
            } else {
                FilterBuilder.processValue(builder, filterParameter.value(), value.toString());
            }
        };
    }
}

