/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudEntity;
import org.cloudfoundry.client.lib.domain.CloudEvent;
import org.cloudfoundry.client.lib.domain.CloudJob;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudQuota;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudSecurityGroup;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceBinding;
import org.cloudfoundry.client.lib.domain.CloudServiceBroker;
import org.cloudfoundry.client.lib.domain.CloudServiceInstance;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudServicePlan;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.CloudStack;
import org.cloudfoundry.client.lib.domain.CloudUser;
import org.cloudfoundry.client.lib.domain.SecurityGroupRule;
import org.cloudfoundry.client.lib.domain.Staging;

public class CloudEntityResourceMapper {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public String getNameOfResource(Map<String, Object> resource) {
        return CloudEntityResourceMapper.getEntityAttribute(resource, "name", String.class);
    }

    public UUID getGuidOfResource(Map<String, Object> resource) {
        return CloudEntityResourceMapper.getMeta(resource).getGuid();
    }

    public <T> T mapResource(Map<String, Object> resource, Class<T> targetClass) {
        if (targetClass == CloudSpace.class) {
            return (T)this.mapSpaceResource(resource);
        }
        if (targetClass == CloudOrganization.class) {
            return (T)this.mapOrganizationResource(resource);
        }
        if (targetClass == CloudDomain.class) {
            return (T)this.mapDomainResource(resource);
        }
        if (targetClass == CloudRoute.class) {
            return (T)this.mapRouteResource(resource);
        }
        if (targetClass == CloudApplication.class) {
            return (T)this.mapApplicationResource(resource);
        }
        if (targetClass == CloudEvent.class) {
            return (T)this.mapEventResource(resource);
        }
        if (targetClass == CloudService.class) {
            return (T)this.mapServiceResource(resource);
        }
        if (targetClass == CloudServiceInstance.class) {
            return (T)this.mapServiceInstanceResource(resource);
        }
        if (targetClass == CloudServiceOffering.class) {
            return (T)this.mapServiceOfferingResource(resource);
        }
        if (targetClass == CloudServiceBroker.class) {
            return (T)this.mapServiceBrokerResource(resource);
        }
        if (targetClass == CloudStack.class) {
            return (T)this.mapStackResource(resource);
        }
        if (targetClass == CloudQuota.class) {
            return (T)this.mapQuotaResource(resource);
        }
        if (targetClass == CloudSecurityGroup.class) {
            return (T)this.mapApplicationSecurityGroupResource(resource);
        }
        if (targetClass == CloudJob.class) {
            return (T)this.mapJobResource(resource);
        }
        if (targetClass == CloudUser.class) {
            return (T)this.mapUserResource(resource);
        }
        throw new IllegalArgumentException("Error during mapping - unsupported class for entity mapping " + targetClass.getName());
    }

    private CloudUser mapUserResource(Map<String, Object> resource) {
        boolean isActiveUser = CloudEntityResourceMapper.getEntityAttribute(resource, "active", Boolean.class);
        boolean isAdminUser = CloudEntityResourceMapper.getEntityAttribute(resource, "admin", Boolean.class);
        String defaultSpaceGuid = CloudEntityResourceMapper.getEntityAttribute(resource, "default_space_guid", String.class);
        String username = CloudEntityResourceMapper.getEntityAttribute(resource, "username", String.class);
        return new CloudUser(CloudEntityResourceMapper.getMeta(resource), username, isAdminUser, isActiveUser, defaultSpaceGuid);
    }

    private CloudSpace mapSpaceResource(Map<String, Object> resource) {
        Map<String, Object> organizationMap = CloudEntityResourceMapper.getEmbeddedResource(resource, "organization");
        CloudOrganization organization = null;
        if (organizationMap != null) {
            organization = this.mapOrganizationResource(organizationMap);
        }
        return new CloudSpace(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), organization);
    }

    private CloudOrganization mapOrganizationResource(Map<String, Object> resource) {
        Boolean billingEnabled = CloudEntityResourceMapper.getEntityAttribute(resource, "billing_enabled", Boolean.class);
        Map<String, Object> quotaDefinition = CloudEntityResourceMapper.getEmbeddedResource(resource, "quota_definition");
        CloudQuota quota = null;
        if (quotaDefinition != null) {
            quota = this.mapQuotaResource(quotaDefinition);
        }
        return new CloudOrganization(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), quota, billingEnabled);
    }

    private CloudQuota mapQuotaResource(Map<String, Object> resource) {
        Boolean nonBasicServicesAllowed = CloudEntityResourceMapper.getEntityAttribute(resource, "non_basic_services_allowed", Boolean.class);
        int totalServices = CloudEntityResourceMapper.getEntityAttribute(resource, "total_services", Integer.class);
        int totalRoutes = CloudEntityResourceMapper.getEntityAttribute(resource, "total_routes", Integer.class);
        long memoryLimit = CloudEntityResourceMapper.getEntityAttribute(resource, "memory_limit", Long.class);
        return new CloudQuota(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), nonBasicServicesAllowed, totalServices, totalRoutes, memoryLimit);
    }

    private CloudDomain mapDomainResource(Map<String, Object> resource) {
        Map ownerResource = CloudEntityResourceMapper.getEntityAttribute(resource, "owning_organization", Map.class);
        CloudOrganization owner = ownerResource == null ? new CloudOrganization(CloudEntity.Meta.defaultMeta(), "none") : this.mapOrganizationResource(ownerResource);
        return new CloudDomain(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), owner);
    }

    private CloudRoute mapRouteResource(Map<String, Object> resource) {
        List apps = CloudEntityResourceMapper.getEntityAttribute(resource, "apps", List.class);
        String host = CloudEntityResourceMapper.getEntityAttribute(resource, "host", String.class);
        CloudDomain domain = this.mapDomainResource(CloudEntityResourceMapper.getEmbeddedResource(resource, "domain"));
        return new CloudRoute(CloudEntityResourceMapper.getMeta(resource), host, domain, apps.size());
    }

    private CloudApplication mapApplicationResource(Map<String, Object> resource) {
        CloudApplication app = new CloudApplication(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource));
        app.setInstances(CloudEntityResourceMapper.getEntityAttribute(resource, "instances", Integer.class));
        app.setServices(new ArrayList<String>());
        app.setState(CloudApplication.AppState.valueOf(CloudEntityResourceMapper.getEntityAttribute(resource, "state", String.class)));
        app.setDebug(null);
        Integer runningInstancesAttribute = CloudEntityResourceMapper.getEntityAttribute(resource, "running_instances", Integer.class);
        if (runningInstancesAttribute != null) {
            app.setRunningInstances(runningInstancesAttribute);
        }
        String command = CloudEntityResourceMapper.getEntityAttribute(resource, "command", String.class);
        String buildpack = CloudEntityResourceMapper.getEntityAttribute(resource, "buildpack", String.class);
        String detectedBuildpack = CloudEntityResourceMapper.getEntityAttribute(resource, "detected_buildpack", String.class);
        Map<String, Object> stackResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "stack");
        CloudStack stack = this.mapStackResource(stackResource);
        Integer healthCheckTimeout = CloudEntityResourceMapper.getEntityAttribute(resource, "health_check_timeout", Integer.class);
        Staging staging = new Staging(command, buildpack, stack.getName(), healthCheckTimeout, detectedBuildpack);
        app.setStaging(staging);
        Map<String, Object> spaceResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "space");
        CloudSpace space = this.mapSpaceResource(spaceResource);
        app.setSpace(space);
        Map envMap = CloudEntityResourceMapper.getEntityAttribute(resource, "environment_json", Map.class);
        if (envMap.size() > 0) {
            app.setEnv(envMap);
        }
        app.setMemory(CloudEntityResourceMapper.getEntityAttribute(resource, "memory", Integer.class));
        app.setDiskQuota(CloudEntityResourceMapper.getEntityAttribute(resource, "disk_quota", Integer.class));
        List serviceBindings = CloudEntityResourceMapper.getEntityAttribute(resource, "service_bindings", List.class);
        ArrayList<String> serviceList = new ArrayList<String>();
        for (Map binding : serviceBindings) {
            Map service = CloudEntityResourceMapper.getEntityAttribute(binding, "service_instance", Map.class);
            String serviceName = this.getNameOfResource(service);
            if (serviceName == null) continue;
            serviceList.add(serviceName);
        }
        app.setServices(serviceList);
        return app;
    }

    private CloudEvent mapEventResource(Map<String, Object> resource) {
        CloudEvent event = new CloudEvent(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource));
        event.setType(CloudEntityResourceMapper.getEntityAttribute(resource, "type", String.class));
        event.setActor(CloudEntityResourceMapper.getEntityAttribute(resource, "actor", String.class));
        event.setActorType(CloudEntityResourceMapper.getEntityAttribute(resource, "actor_type", String.class));
        event.setActorName(CloudEntityResourceMapper.getEntityAttribute(resource, "actor_name", String.class));
        event.setActee(CloudEntityResourceMapper.getEntityAttribute(resource, "actee", String.class));
        event.setActeeType(CloudEntityResourceMapper.getEntityAttribute(resource, "actee_type", String.class));
        event.setActeeName(CloudEntityResourceMapper.getEntityAttribute(resource, "actee_name", String.class));
        Date timestamp = CloudEntityResourceMapper.parseDate(CloudEntityResourceMapper.getEntityAttribute(resource, "timestamp", String.class));
        event.setTimestamp(timestamp);
        return event;
    }

    private CloudService mapServiceResource(Map<String, Object> resource) {
        CloudService cloudService = new CloudService(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource));
        Map<String, Object> servicePlanResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "service_plan");
        if (servicePlanResource != null) {
            cloudService.setPlan(CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "name", String.class));
            Map<String, Object> serviceResource = CloudEntityResourceMapper.getEmbeddedResource(servicePlanResource, "service");
            if (serviceResource != null) {
                cloudService.setLabel(CloudEntityResourceMapper.getEntityAttribute(serviceResource, "label", String.class));
                cloudService.setProvider(CloudEntityResourceMapper.getEntityAttribute(serviceResource, "provider", String.class));
                cloudService.setVersion(CloudEntityResourceMapper.getEntityAttribute(serviceResource, "version", String.class));
            }
        }
        return cloudService;
    }

    private CloudServiceInstance mapServiceInstanceResource(Map<String, Object> resource) {
        CloudServiceInstance serviceInstance = new CloudServiceInstance(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource));
        serviceInstance.setType(CloudEntityResourceMapper.getEntityAttribute(resource, "type", String.class));
        serviceInstance.setDashboardUrl(CloudEntityResourceMapper.getEntityAttribute(resource, "dashboard_url", String.class));
        serviceInstance.setCredentials(CloudEntityResourceMapper.getEntityAttribute(resource, "credentials", Map.class));
        Map<String, Object> servicePlanResource = CloudEntityResourceMapper.getEmbeddedResource(resource, "service_plan");
        serviceInstance.setServicePlan(this.mapServicePlanResource(servicePlanResource));
        CloudService service = this.mapServiceResource(resource);
        serviceInstance.setService(service);
        List<Map<String, Object>> bindingsResource = CloudEntityResourceMapper.getEmbeddedResourceList(CloudEntityResourceMapper.getEntity(resource), "service_bindings");
        ArrayList<CloudServiceBinding> bindings = new ArrayList<CloudServiceBinding>(bindingsResource.size());
        for (Map<String, Object> bindingResource : bindingsResource) {
            bindings.add(this.mapServiceBinding(bindingResource));
        }
        serviceInstance.setBindings(bindings);
        return serviceInstance;
    }

    private CloudServiceBinding mapServiceBinding(Map<String, Object> resource) {
        CloudServiceBinding binding = new CloudServiceBinding(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource));
        binding.setAppGuid(UUID.fromString(CloudEntityResourceMapper.getEntityAttribute(resource, "app_guid", String.class)));
        binding.setSyslogDrainUrl(CloudEntityResourceMapper.getEntityAttribute(resource, "syslog_drain_url", String.class));
        binding.setCredentials(CloudEntityResourceMapper.getEntityAttribute(resource, "credentials", Map.class));
        binding.setBindingOptions(CloudEntityResourceMapper.getEntityAttribute(resource, "binding_options", Map.class));
        return binding;
    }

    private CloudServiceOffering mapServiceOfferingResource(Map<String, Object> resource) {
        CloudServiceOffering cloudServiceOffering = new CloudServiceOffering(CloudEntityResourceMapper.getMeta(resource), CloudEntityResourceMapper.getEntityAttribute(resource, "label", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "provider", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "version", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "description", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "active", Boolean.class), CloudEntityResourceMapper.getEntityAttribute(resource, "bindable", Boolean.class), CloudEntityResourceMapper.getEntityAttribute(resource, "url", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "info_url", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "unique_id", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "extra", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "documentation_url", String.class));
        List<Map<String, Object>> servicePlanList = CloudEntityResourceMapper.getEmbeddedResourceList(CloudEntityResourceMapper.getEntity(resource), "service_plans");
        if (servicePlanList != null) {
            for (Map<String, Object> servicePlanResource : servicePlanList) {
                CloudServicePlan servicePlan = this.mapServicePlanResource(servicePlanResource);
                servicePlan.setServiceOffering(cloudServiceOffering);
                cloudServiceOffering.addCloudServicePlan(servicePlan);
            }
        }
        return cloudServiceOffering;
    }

    private CloudServicePlan mapServicePlanResource(Map<String, Object> servicePlanResource) {
        Boolean publicPlan = CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "public", Boolean.class);
        return new CloudServicePlan(CloudEntityResourceMapper.getMeta(servicePlanResource), CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "name", String.class), CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "description", String.class), CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "free", Boolean.class), publicPlan == null ? true : publicPlan, CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "extra", String.class), CloudEntityResourceMapper.getEntityAttribute(servicePlanResource, "unique_id", String.class));
    }

    private CloudServiceBroker mapServiceBrokerResource(Map<String, Object> resource) {
        return new CloudServiceBroker(CloudEntityResourceMapper.getMeta(resource), CloudEntityResourceMapper.getEntityAttribute(resource, "name", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "broker_url", String.class), CloudEntityResourceMapper.getEntityAttribute(resource, "auth_username", String.class));
    }

    private CloudStack mapStackResource(Map<String, Object> resource) {
        return new CloudStack(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), CloudEntityResourceMapper.getEntityAttribute(resource, "description", String.class));
    }

    private CloudSecurityGroup mapApplicationSecurityGroupResource(Map<String, Object> resource) {
        return new CloudSecurityGroup(CloudEntityResourceMapper.getMeta(resource), this.getNameOfResource(resource), this.getSecurityGroupRules(resource), CloudEntityResourceMapper.getEntityAttribute(resource, "running_default", Boolean.class), CloudEntityResourceMapper.getEntityAttribute(resource, "staging_default", Boolean.class));
    }

    private List<SecurityGroupRule> getSecurityGroupRules(Map<String, Object> resource) {
        ArrayList<SecurityGroupRule> rules = new ArrayList<SecurityGroupRule>();
        List jsonRules = CloudEntityResourceMapper.getEntityAttribute(resource, "rules", List.class);
        for (Map jsonRule : jsonRules) {
            rules.add(new SecurityGroupRule((String)jsonRule.get("protocol"), (String)jsonRule.get("ports"), (String)jsonRule.get("destination"), (Boolean)jsonRule.get("log"), (Integer)jsonRule.get("type"), (Integer)jsonRule.get("code")));
        }
        return rules;
    }

    private CloudJob mapJobResource(Map<String, Object> resource) {
        String status = CloudEntityResourceMapper.getEntityAttribute(resource, "status", String.class);
        Map errorDetailsResource = (Map)resource.get("error_details");
        CloudJob.ErrorDetails errorDetails = null;
        if (errorDetailsResource != null) {
            Long code = CloudEntityResourceMapper.getEntityAttribute(errorDetailsResource, "code", Long.class);
            String description = CloudEntityResourceMapper.getEntityAttribute(errorDetailsResource, "description", String.class);
            String errorCode = CloudEntityResourceMapper.getEntityAttribute(errorDetailsResource, "error_code", String.class);
            errorDetails = new CloudJob.ErrorDetails(code, description, errorCode);
        }
        return new CloudJob(CloudEntityResourceMapper.getMeta(resource), CloudJob.Status.getEnum(status), errorDetails);
    }

    public static CloudEntity.Meta getMeta(Map<String, Object> resource) {
        UUID guid;
        Map metadata = (Map)resource.get("metadata");
        try {
            guid = UUID.fromString(String.valueOf(metadata.get("guid")));
        }
        catch (IllegalArgumentException e) {
            guid = null;
        }
        Date createdDate = CloudEntityResourceMapper.parseDate(String.valueOf(metadata.get("created_at")));
        Date updatedDate = CloudEntityResourceMapper.parseDate(String.valueOf(metadata.get("updated_at")));
        String url = String.valueOf(metadata.get("url"));
        return new CloudEntity.Meta(guid, createdDate, updatedDate, url);
    }

    private static Date parseDate(String dateString) {
        if (dateString != null) {
            try {
                String isoDateString = dateString.replaceFirst(":(?=[0-9]{2}$)", "").replaceFirst("Z$", "+0000");
                return dateFormatter.parse(isoDateString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, Object> getEntity(Map<String, Object> resource) {
        return (Map)resource.get("entity");
    }

    public static <T> T getEntityAttribute(Map<String, Object> resource, String attributeName, Class<T> targetClass) {
        if (resource == null) {
            return null;
        }
        Map entity = (Map)resource.get("entity");
        Object attributeValue = entity.get(attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (targetClass == String.class) {
            return (T)String.valueOf(attributeValue);
        }
        if (targetClass == Long.class) {
            return (T)Long.valueOf(String.valueOf(attributeValue));
        }
        if (targetClass == Integer.class || targetClass == Boolean.class || targetClass == Map.class || targetClass == List.class) {
            return (T)attributeValue;
        }
        if (targetClass == UUID.class && attributeValue instanceof String) {
            return (T)UUID.fromString((String)attributeValue);
        }
        throw new IllegalArgumentException("Error during mapping - unsupported class for attribute mapping " + targetClass.getName());
    }

    public static Map<String, Object> getEmbeddedResource(Map<String, Object> resource, String embeddedResourceName) {
        Map entity = (Map)resource.get("entity");
        return (Map)entity.get(embeddedResourceName);
    }

    public static List<Map<String, Object>> getEmbeddedResourceList(Map<String, Object> resource, String embeddedResourceName) {
        return (List)resource.get(embeddedResourceName);
    }
}

