(ns protocol55.allot.core)

(defn allot-1
 ([m k1]
  (list m))
 ([m k1 k2]
  (list (dissoc m k2)
        (dissoc m k1)))
 ([m k1 k2 & ks]
  (let [ks (set ks)]
    (map #(apply dissoc m k1 k2 (disj ks %)) ks))))

(defn allot-by
  "Divides a map m into a seq of maps each with only a single occurance of any
  key produced by (ks-f m). Returns nil if no such keys exist in m."
 [m ks-f]
 (when-some [ks (seq (ks-f m))]
    (apply allot-1 m ks)))

(defn- keys-of-name [x m]
  (let [n (name x)]
    (->> m keys (filter #(= n (name %))))))

(defn allot
  "Divides a map m into a seq of maps each with only a single occurance of any
  key with name n. Returns nil if no such keys exist in m."
  [m n]
  (allot-by m (partial keys-of-name n)))
