/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.hadoop.util.DeserializerComparator;
import cascading.tuple.io.IndexTuple;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;

public class IndexTupleCoGroupingComparator
extends DeserializerComparator<IndexTuple>
implements Configurable {
    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        try {
            this.lhsBuffer.reset(b1, s1, l1);
            this.rhsBuffer.reset(b2, s2, l2);
            int lhsIndex = this.lhsStream.readVInt();
            int rhsIndex = this.rhsStream.readVInt();
            int c = this.compareTuples(this.groupComparators);
            if (c != 0) {
                int n = c;
                return n;
            }
            int n = rhsIndex - lhsIndex;
            return n;
        }
        catch (IOException exception) {
            throw new CascadingException((Throwable)exception);
        }
        finally {
            this.lhsBuffer.clear();
            this.rhsBuffer.clear();
        }
    }

    public int compare(IndexTuple lhs, IndexTuple rhs) {
        int c = this.compareTuples(this.groupComparators, lhs.getTuple(), rhs.getTuple());
        if (c != 0) {
            return c;
        }
        return rhs.getIndex() - lhs.getIndex();
    }
}

