/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tuple.Fields;
import cascading.tuple.StreamComparator;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BufferedInputStream;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.hadoop.util.DelegatingTupleElementComparator;
import cascading.tuple.hadoop.util.TupleElementComparator;
import cascading.tuple.hadoop.util.TupleElementStreamComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.RawComparator;

public abstract class DeserializerComparator<T>
extends Configured
implements RawComparator<T> {
    final BufferedInputStream lhsBuffer = new BufferedInputStream();
    final BufferedInputStream rhsBuffer = new BufferedInputStream();
    TupleSerialization tupleSerialization;
    HadoopTupleInputStream lhsStream;
    HadoopTupleInputStream rhsStream;
    Comparator[] groupComparators;

    public void setConf(Configuration conf) {
        if (conf == null) {
            return;
        }
        super.setConf(conf);
        this.tupleSerialization = new TupleSerialization(conf);
        this.lhsStream = new HadoopTupleInputStream(this.lhsBuffer, this.tupleSerialization.getElementReader());
        this.rhsStream = new HadoopTupleInputStream(this.rhsBuffer, this.tupleSerialization.getElementReader());
        this.groupComparators = this.deserializeComparatorsFor("cascading.group.comparator");
        this.groupComparators = this.delegatingComparatorsFor(this.groupComparators);
    }

    Comparator[] deserializeComparatorsFor(String name) {
        Configuration conf = this.getConf();
        if (conf == null) {
            throw new IllegalStateException("no conf set");
        }
        return DeserializerComparator.getFieldComparatorsFrom(conf, name);
    }

    public static Comparator[] getFieldComparatorsFrom(Configuration conf, String name) {
        String value = conf.get(name);
        if (value == null) {
            return new Comparator[conf.getInt(name + ".size", 1)];
        }
        try {
            return HadoopUtil.deserializeBase64(value, conf, Fields.class).getComparators();
        }
        catch (IOException exception) {
            throw new CascadingException("unable to deserialize comparators for: " + name);
        }
    }

    Comparator[] delegatingComparatorsFor(Comparator[] fieldComparators) {
        Comparator[] comparators = new Comparator[fieldComparators.length];
        for (int i = 0; i < comparators.length; ++i) {
            comparators[i] = fieldComparators[i] instanceof StreamComparator ? new TupleElementStreamComparator((StreamComparator)fieldComparators[i]) : (fieldComparators[i] != null ? new TupleElementComparator(fieldComparators[i]) : new DelegatingTupleElementComparator(this.tupleSerialization));
        }
        return comparators;
    }

    final int compareTuples(Comparator[] comparators, Tuple lhs, Tuple rhs) {
        int rhsLen;
        int lhsLen = lhs.size();
        int c = lhsLen - (rhsLen = rhs.size());
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < lhsLen; ++i) {
            Object lhsObject = lhs.getObject(i);
            Object rhsObject = rhs.getObject(i);
            try {
                c = comparators[i % comparators.length].compare(lhsObject, rhsObject);
            }
            catch (Exception exception) {
                throw new CascadingException("unable to compare object elements in position: " + i + " lhs: '" + lhsObject + "' rhs: '" + rhsObject + "'", (Throwable)exception);
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    final int compareTuples(Comparator[] comparators) throws IOException {
        int rhsLen;
        int lhsLen = this.lhsStream.getNumElements();
        int c = lhsLen - (rhsLen = this.rhsStream.getNumElements());
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < lhsLen; ++i) {
            try {
                c = ((StreamComparator)comparators[i % comparators.length]).compare((InputStream)((Object)this.lhsStream), (InputStream)((Object)this.rhsStream));
            }
            catch (Exception exception) {
                throw new CascadingException("unable to compare stream elements in position: " + i, (Throwable)exception);
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

