/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.property.Props;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TupleSerializationProps
extends Props {
    public static final String SERIALIZATION_TOKENS = "cascading.serialization.tokens";
    public static final String HADOOP_IO_SERIALIZATIONS = "io.serializations";
    Map<Integer, String> serializationTokens = new LinkedHashMap<Integer, String>();
    List<String> hadoopSerializations = new ArrayList<String>();

    public static void addSerializationToken(Map<Object, Object> properties, int token, String className) {
        String tokens = TupleSerializationProps.getSerializationTokens(properties);
        properties.put(SERIALIZATION_TOKENS, Util.join((String)",", (String[])Util.removeNulls((String[])new String[]{tokens, token + "=" + className})));
    }

    public static String getSerializationTokens(Map<Object, Object> properties) {
        return (String)properties.get(SERIALIZATION_TOKENS);
    }

    public static void addSerialization(Map<Object, Object> properties, String className) {
        String serializations = (String)properties.get(HADOOP_IO_SERIALIZATIONS);
        properties.put(HADOOP_IO_SERIALIZATIONS, Util.join((String)",", (String[])Util.removeNulls((String[])new String[]{serializations, className})));
    }

    public static TupleSerializationProps tupleSerializationProps() {
        return new TupleSerializationProps();
    }

    public Map<Integer, String> getSerializationTokens() {
        return this.serializationTokens;
    }

    public TupleSerializationProps setSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens = serializationTokens;
        return this;
    }

    public TupleSerializationProps addSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens.putAll(serializationTokens);
        return this;
    }

    public TupleSerializationProps addSerializationToken(int token, String serialization) {
        this.serializationTokens.put(token, serialization);
        return this;
    }

    public List<String> getHadoopSerializations() {
        return this.hadoopSerializations;
    }

    public TupleSerializationProps setHadoopSerializations(List<String> hadoopSerializations) {
        this.hadoopSerializations = hadoopSerializations;
        return this;
    }

    public TupleSerializationProps addHadoopSerializations(List<String> hadoopSerializations) {
        this.hadoopSerializations.addAll(hadoopSerializations);
        return this;
    }

    public TupleSerializationProps addHadoopSerialization(String hadoopSerialization) {
        this.hadoopSerializations.add(hadoopSerialization);
        return this;
    }

    protected void addPropertiesTo(Properties properties) {
        for (Map.Entry<Integer, String> entry : this.serializationTokens.entrySet()) {
            TupleSerializationProps.addSerializationToken(properties, entry.getKey(), entry.getValue());
        }
        for (String hadoopSerialization : this.hadoopSerializations) {
            TupleSerializationProps.addSerialization(properties, hadoopSerialization);
        }
    }
}

