/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.tuple.Comparison;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.hadoop.SerializationToken;
import cascading.tuple.hadoop.TupleSerializationProps;
import cascading.tuple.hadoop.io.IndexTupleDeserializer;
import cascading.tuple.hadoop.io.IndexTupleSerializer;
import cascading.tuple.hadoop.io.TupleDeserializer;
import cascading.tuple.hadoop.io.TuplePairDeserializer;
import cascading.tuple.hadoop.io.TuplePairSerializer;
import cascading.tuple.hadoop.io.TupleSerializer;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.io.TuplePair;
import cascading.util.Util;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerializationToken(tokens={127}, classNames={"org.apache.hadoop.io.BytesWritable"})
public class TupleSerialization
extends Configured
implements Serialization {
    private static final Logger LOG = LoggerFactory.getLogger(TupleSerialization.class);
    private Comparator defaultComparator;
    private final Map<String, Class> classCache = new HashMap<String, Class>();
    private SerializationFactory serializationFactory;
    private HashMap<Integer, String> tokenClassesMap;
    private HashMap<String, Integer> classesTokensMap;
    private long tokensSize = 0L;

    @Deprecated
    public static void addSerializationToken(Map<Object, Object> properties, int token, String className) {
        TupleSerializationProps.addSerializationToken(properties, token, className);
    }

    @Deprecated
    public static String getSerializationTokens(Map<Object, Object> properties) {
        return TupleSerializationProps.getSerializationTokens(properties);
    }

    static String getSerializationTokens(Configuration jobConf) {
        return jobConf.get("cascading.serialization.tokens");
    }

    @Deprecated
    public static void addSerialization(Map<Object, Object> properties, String className) {
        TupleSerializationProps.addSerialization(properties, className);
    }

    public static void setSerializations(JobConf jobConf) {
        String serializations = TupleSerialization.getSerializations((Configuration)jobConf);
        LinkedList<String> list = new LinkedList<String>();
        if (serializations != null && !serializations.isEmpty()) {
            Collections.addAll(list, serializations.split(","));
        }
        String writable = WritableSerialization.class.getName();
        String tuple = TupleSerialization.class.getName();
        list.remove(writable);
        list.remove(tuple);
        list.addFirst(writable);
        list.addFirst(tuple);
        jobConf.set("io.serializations", Util.join(list, (String)","));
    }

    static String getSerializations(Configuration jobConf) {
        return jobConf.get("io.serializations", null);
    }

    public static Comparator getDefaultComparator(Configuration jobConf) {
        String typeName = jobConf.get("cascading.flow.tuple.element.comparator");
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        LOG.info("using default comparator: {}", (Object)typeName);
        try {
            Class<?> type = TupleSerialization.class.getClassLoader().loadClass(typeName.toString());
            return (Comparator)ReflectionUtils.newInstance(type, (Configuration)jobConf);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + typeName.toString(), (Throwable)exception);
        }
    }

    public TupleSerialization() {
    }

    public TupleSerialization(final FlowProcess<JobConf> flowProcess) {
        super(new Configuration(){

            public String get(String name) {
                return this.get(name, null);
            }

            public String get(String name, String defaultValue) {
                Object value = flowProcess.getProperty(name);
                return value == null ? defaultValue : String.valueOf(value);
            }
        });
    }

    public TupleSerialization(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.defaultComparator = TupleSerialization.getDefaultComparator(conf);
        }
    }

    public Configuration getConf() {
        if (super.getConf() == null) {
            this.setConf((Configuration)new JobConf());
        }
        return super.getConf();
    }

    SerializationFactory getSerializationFactory() {
        if (this.serializationFactory == null) {
            this.serializationFactory = new SerializationFactory(this.getConf());
        }
        return this.serializationFactory;
    }

    void initTokenMaps() {
        String[] serializations;
        String serializationsString;
        if (this.tokenClassesMap != null) {
            return;
        }
        this.tokenClassesMap = new HashMap();
        this.classesTokensMap = new HashMap();
        String tokenProperty = TupleSerialization.getSerializationTokens(this.getConf());
        if (tokenProperty != null) {
            tokenProperty = tokenProperty.replaceAll("\\s", "");
            for (String pair : tokenProperty.split(",")) {
                String[] elements = pair.split("=");
                this.addToken(null, Integer.parseInt(elements[0]), elements[1]);
            }
        }
        if ((serializationsString = TupleSerialization.getSerializations(this.getConf())) == null) {
            return;
        }
        for (String serializationName : serializations = serializationsString.split(",")) {
            try {
                Class type = this.getConf().getClassByName(serializationName);
                SerializationToken tokenAnnotation = type.getAnnotation(SerializationToken.class);
                if (tokenAnnotation == null) continue;
                if (tokenAnnotation.tokens().length != tokenAnnotation.classNames().length) {
                    throw new CascadingException("serialization annotation tokens and classNames must be the same length");
                }
                int[] tokens = tokenAnnotation.tokens();
                for (int i = 0; i < tokens.length; ++i) {
                    this.addToken(type, tokens[i], tokenAnnotation.classNames()[i]);
                }
            }
            catch (ClassNotFoundException exception) {
                LOG.warn("unable to load serialization class: {}", (Object)serializationName, (Object)exception);
            }
        }
        this.tokensSize = this.tokenClassesMap.size();
    }

    private void addToken(Class type, int token, String className) {
        if (type != null && !type.getName().startsWith("cascading.") && token < 128) {
            throw new CascadingException("serialization annotation tokens may not be less than 128, was: " + token);
        }
        if (this.tokenClassesMap.containsKey(token)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization token: " + token + " for class: " + className + " found in properties");
            }
            throw new IllegalStateException("duplicate serialization token: " + token + " for class: " + className + " on serialization: " + type.getName());
        }
        if (this.classesTokensMap.containsKey(className)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token + " found in properties ");
            }
            throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token + " on serialization: " + type.getName());
        }
        this.tokenClassesMap.put(token, className);
        this.classesTokensMap.put(className, token);
    }

    final String getClassNameFor(int token) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.tokenClassesMap.get(token);
    }

    final Integer getTokenFor(String className) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.classesTokensMap.get(className);
    }

    public Comparator getDefaultComparator() {
        return this.defaultComparator;
    }

    public Comparator getComparator(Class type) {
        Serialization serialization = this.getSerialization(type);
        Comparator comparator = null;
        if (serialization instanceof Comparison) {
            comparator = ((Comparison)serialization).getComparator(type);
        }
        if (comparator != null) {
            return comparator;
        }
        return this.defaultComparator;
    }

    Serialization getSerialization(String className) {
        return this.getSerialization(this.getClass(className));
    }

    Serialization getSerialization(Class type) {
        return this.getSerializationFactory().getSerialization(type);
    }

    Serializer getNewSerializer(Class type) {
        try {
            Serializer serializer = this.getSerializationFactory().getSerializer(type);
            if (serializer == null) {
                throw new CascadingException("unable to load serializer for: " + type.getName() + " from: " + this.getSerializationFactory().getClass().getName());
            }
            return serializer;
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load serializer for: " + type.getName() + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    Deserializer getNewDeserializer(String className) {
        try {
            Deserializer deserializer = this.getSerializationFactory().getDeserializer(this.getClass(className));
            if (deserializer == null) {
                throw new CascadingException("unable to load deserializer for: " + className + " from: " + this.getSerializationFactory().getClass().getName());
            }
            return deserializer;
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load deserializer for: " + className + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    TuplePairDeserializer getTuplePairDeserializer() {
        return new TuplePairDeserializer(this.getElementReader());
    }

    public SerializationElementReader getElementReader() {
        return new SerializationElementReader(this);
    }

    TupleDeserializer getTupleDeserializer() {
        return new TupleDeserializer(this.getElementReader());
    }

    private TuplePairSerializer getTuplePairSerializer() {
        return new TuplePairSerializer(this.getElementWriter());
    }

    IndexTupleDeserializer getIndexTupleDeserializer() {
        return new IndexTupleDeserializer(this.getElementReader());
    }

    public SerializationElementWriter getElementWriter() {
        return new SerializationElementWriter(this);
    }

    private TupleSerializer getTupleSerializer() {
        return new TupleSerializer(this.getElementWriter());
    }

    private IndexTupleSerializer getIndexTupleSerializer() {
        return new IndexTupleSerializer(this.getElementWriter());
    }

    public boolean accept(Class c) {
        return Tuple.class == c || TuplePair.class == c || IndexTuple.class == c;
    }

    public Deserializer getDeserializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleDeserializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairDeserializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleDeserializer();
        }
        throw new IllegalArgumentException("unknown class, cannot deserialize: " + c.getName());
    }

    public Serializer getSerializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleSerializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairSerializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleSerializer();
        }
        throw new IllegalArgumentException("unknown class, cannot serialize: " + c.getName());
    }

    public Class getClass(String className) {
        Class<?> type = this.classCache.get(className);
        if (type != null) {
            return type;
        }
        try {
            type = className.charAt(0) == '[' ? Class.forName(className, true, Thread.currentThread().getContextClassLoader()) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new TupleException("unable to load class named: " + className, (Throwable)exception);
        }
        this.classCache.put(className, type);
        return type;
    }

    public static class SerializationElementWriter
    implements TupleOutputStream.ElementWriter {
        private static final Logger LOG = LoggerFactory.getLogger(SerializationElementWriter.class);
        private final TupleSerialization tupleSerialization;
        final Map<Class, Serializer> serializers = new HashMap<Class, Serializer>();

        public SerializationElementWriter(TupleSerialization tupleSerialization) {
            this.tupleSerialization = tupleSerialization;
            tupleSerialization.initTokenMaps();
        }

        public void write(DataOutputStream outputStream, Object object) throws IOException {
            Class<?> type = object.getClass();
            String className = type.getName();
            Integer token = this.tupleSerialization.getTokenFor(className);
            if (token == null) {
                LOG.debug("no serialization token found for classname: {}", (Object)className);
                WritableUtils.writeVInt((DataOutput)outputStream, (int)32);
                WritableUtils.writeString((DataOutput)outputStream, (String)className);
            } else {
                WritableUtils.writeVInt((DataOutput)outputStream, (int)token);
            }
            Serializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = this.tupleSerialization.getNewSerializer(type);
                serializer.open((OutputStream)outputStream);
                this.serializers.put(type, serializer);
            }
            try {
                serializer.serialize(object);
            }
            catch (IOException exception) {
                LOG.error("failed serializing token: " + token + " with classname: " + className, (Throwable)exception);
                throw exception;
            }
        }

        public void close() {
            if (this.serializers.size() == 0) {
                return;
            }
            ArrayList<Serializer> clone = new ArrayList<Serializer>(this.serializers.values());
            this.serializers.clear();
            for (Serializer serializer : clone) {
                try {
                    serializer.close();
                }
                catch (IOException exception) {}
            }
        }
    }

    public static class SerializationElementReader
    implements TupleInputStream.ElementReader {
        private static final Logger LOG = LoggerFactory.getLogger(SerializationElementReader.class);
        private final TupleSerialization tupleSerialization;
        final Map<String, Deserializer> deserializers = new HashMap<String, Deserializer>();

        public SerializationElementReader(TupleSerialization tupleSerialization) {
            this.tupleSerialization = tupleSerialization;
            tupleSerialization.initTokenMaps();
        }

        public Object read(int token, DataInputStream inputStream) throws IOException {
            String className = this.getClassNameFor(token, inputStream);
            Deserializer deserializer = this.getDeserializerFor(inputStream, className);
            Object foundObject = null;
            Object object = null;
            try {
                object = deserializer.deserialize(foundObject);
            }
            catch (IOException exception) {
                LOG.error("failed deserializing token: " + token + " with classname: " + className, (Throwable)exception);
                throw exception;
            }
            return object;
        }

        public Comparator getComparatorFor(int token, DataInputStream inputStream) throws IOException {
            Class type = this.tupleSerialization.getClass(this.getClassNameFor(token, inputStream));
            return this.tupleSerialization.getComparator(type);
        }

        private Deserializer getDeserializerFor(DataInputStream inputStream, String className) throws IOException {
            Deserializer deserializer = this.deserializers.get(className);
            if (deserializer == null) {
                deserializer = this.tupleSerialization.getNewDeserializer(className);
                deserializer.open((InputStream)inputStream);
                this.deserializers.put(className, deserializer);
            }
            return deserializer;
        }

        public String getClassNameFor(int token, DataInputStream inputStream) throws IOException {
            String className = this.tupleSerialization.getClassNameFor(token);
            if (className == null) {
                className = WritableUtils.readString((DataInput)inputStream);
            }
            return className;
        }

        public void close() {
            if (this.deserializers.size() == 0) {
                return;
            }
            ArrayList<Deserializer> clone = new ArrayList<Deserializer>(this.deserializers.values());
            this.deserializers.clear();
            for (Deserializer deserializer : clone) {
                try {
                    deserializer.close();
                }
                catch (IOException exception) {}
            }
        }
    }
}

