/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.Tuple;
import cascading.tuple.hadoop.BytesSerialization;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.util.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.JobConf;

public class TupleAdapter
extends Tuple
implements WritableComparable<Object> {
    public static final TupleAdapter NULL = new TupleAdapter(Tuple.NULL);
    private static final TupleSerialization INSTANCE = TupleAdapter.getConfiguredSerialization();
    private static final long serialVersionUID = -1754479390339141442L;

    public TupleAdapter() {
    }

    public TupleAdapter(ArrayList<Object> elements) {
        super(elements);
    }

    public TupleAdapter(Object ... values) {
        super(values);
    }

    public TupleAdapter(Tuple tuple) {
        super(tuple);
    }

    public void readFields(DataInput arg0) throws IOException {
        HadoopTupleInputStream is = new HadoopTupleInputStream((InputStream)((Object)arg0), INSTANCE.getElementReader());
        is.readTuple(this);
    }

    public void write(DataOutput arg0) throws IOException {
        HadoopTupleOutputStream os = new HadoopTupleOutputStream((OutputStream)((Object)arg0), INSTANCE.getElementWriter());
        os.writeTuple(this);
    }

    private static TupleSerialization getConfiguredSerialization() {
        JobConf conf = new JobConf();
        List<String> classes = Arrays.asList(BytesSerialization.class.getName(), TupleSerialization.class.getName(), WritableSerialization.class.getName(), JavaSerialization.class.getName());
        conf.set("io.serializations", Util.join(classes, (String)","));
        TupleSerialization s = new TupleSerialization((Configuration)conf);
        return s;
    }
}

