/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TempHfs
extends Hfs {
    final String name;
    private Class<? extends Scheme> schemeClass;

    public TempHfs(JobConf conf, String name, boolean isNull) {
        super(isNull ? new NullScheme() : new SequenceFile(){});
        this.name = name;
        this.stringPath = this.initTemporaryPath(conf, true);
    }

    public TempHfs(JobConf conf, String name, Class<? extends Scheme> schemeClass) {
        this(conf, name, schemeClass, true);
    }

    public TempHfs(JobConf conf, String name, Class<? extends Scheme> schemeClass, boolean unique) {
        this.name = name;
        this.schemeClass = schemeClass == null ? SequenceFile.class : schemeClass;
        this.stringPath = this.initTemporaryPath(conf, unique);
    }

    public Class<? extends Scheme> getSchemeClass() {
        return this.schemeClass;
    }

    private String initTemporaryPath(JobConf conf, boolean unique) {
        String child = unique ? this.makeTemporaryPathDirString(this.name) : this.name;
        return new Path(TempHfs.getTempPath(conf), child).toString();
    }

    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields fields = incomingScopes.iterator().next().getIncomingTapFields();
        this.setSchemeUsing(fields);
        return new Scope(fields);
    }

    private void setSchemeUsing(Fields fields) {
        try {
            this.setScheme(this.schemeClass.getConstructor(Fields.class).newInstance(fields));
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create specified scheme: " + this.schemeClass.getName(), (Throwable)exception);
        }
    }

    public boolean isTemporary() {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[" + this.name + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TempHfs tempHfs = (TempHfs)((Object)object);
        return !(this.name != null ? !this.name.equals(tempHfs.name) : tempHfs.name != null);
    }

    public int hashCode() {
        return 31 * (System.identityHashCode((Object)this) + this.name != null ? this.name.hashCode() : 0);
    }

    private static class NullScheme
    extends Scheme<JobConf, RecordReader, OutputCollector, Object, Object> {
        private NullScheme() {
        }

        public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        }

        public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
            conf.setOutputKeyClass(Tuple.class);
            conf.setOutputValueClass(Tuple.class);
            conf.setOutputFormat(NullOutputFormat.class);
        }

        public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object, RecordReader> sourceCall) throws IOException {
            return false;
        }

        public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object, OutputCollector> sinkCall) throws IOException {
        }
    }
}

