/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.util.Hadoop18TapUtil;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapOutputCollector
implements OutputCollector,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TapOutputCollector.class);
    private JobConf conf;
    private RecordWriter writer;
    private String filenamePattern = "%s%spart-%05d";
    private String filename;
    private Tap<JobConf, RecordReader, OutputCollector> tap;
    private String prefix;
    private boolean isFileOutputFormat;
    private final Reporter reporter = Reporter.NULL;
    private final FlowProcess<JobConf> flowProcess;

    public TapOutputCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap) throws IOException {
        this(flowProcess, tap, null);
    }

    public TapOutputCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, String prefix) throws IOException {
        this.tap = tap;
        this.prefix = prefix == null || prefix.length() == 0 ? null : prefix;
        this.flowProcess = flowProcess;
        this.conf = (JobConf)this.flowProcess.getConfigCopy();
        this.filenamePattern = this.conf.get("cascading.tapcollector.partname", this.filenamePattern);
        this.initialize();
    }

    protected void initialize() throws IOException {
        this.tap.sinkConfInit(this.flowProcess, (Object)this.conf);
        OutputFormat outputFormat = this.conf.getOutputFormat();
        this.isFileOutputFormat = outputFormat instanceof FileOutputFormat;
        if (this.isFileOutputFormat) {
            Hadoop18TapUtil.setupJob(this.conf);
            this.filename = this.prefix != null ? String.format(this.filenamePattern, this.prefix, "/", this.conf.getInt("mapred.task.partition", 0)) : String.format(this.filenamePattern, "", "", this.conf.getInt("mapred.task.partition", 0));
            Hadoop18TapUtil.setupTask(this.conf);
        }
        this.writer = outputFormat.getRecordWriter(null, this.conf, this.filename, (Progressable)Reporter.NULL);
    }

    public void collect(Object writableComparable, Object writable) throws IOException {
        this.flowProcess.keepAlive();
        this.writer.write(writableComparable, writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isFileOutputFormat) {
                LOG.info("closing tap collector for: {}", (Object)new Path(this.tap.getIdentifier(), this.filename));
            } else {
                LOG.info("closing tap collector for: {}", this.tap);
            }
            try {
                this.writer.close(this.reporter);
            }
            finally {
                if (this.isFileOutputFormat) {
                    if (Hadoop18TapUtil.needsTaskCommit(this.conf)) {
                        Hadoop18TapUtil.commitTask(this.conf);
                    }
                    Hadoop18TapUtil.cleanupJob(this.conf);
                }
            }
        }
        catch (IOException exception) {
            LOG.warn("exception closing: {}", (Object)this.filename, (Object)exception);
            throw new TapException("exception closing: " + this.filename, (Throwable)exception);
        }
    }
}

