/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.tap.hadoop.io.FSDigestInputStream;
import cascading.tap.hadoop.io.StreamedFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFileSystem
extends StreamedFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFileSystem.class);
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    private String scheme;
    private String authority;

    public void initialize(URI uri, Configuration configuration) throws IOException {
        this.setConf(configuration);
        this.scheme = uri.getScheme();
        this.authority = uri.getAuthority();
    }

    public URI getUri() {
        try {
            return new URI(this.scheme, this.authority, null, null, null);
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("failed parsing uri", exception);
        }
    }

    public FileStatus[] globStatus(Path path, PathFilter pathFilter) throws IOException {
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus == null) {
            return null;
        }
        return new FileStatus[]{fileStatus};
    }

    public FSDataInputStream open(Path path, int i) throws IOException {
        URL url = this.makeUrl(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        this.debugConnection(connection);
        return new FSDataInputStream((InputStream)((Object)new FSDigestInputStream(connection.getInputStream(), HttpFileSystem.getMD5SumFor(this.getConf(), path))));
    }

    public boolean exists(Path path) throws IOException {
        URL url = this.makeUrl(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.connect();
        this.debugConnection(connection);
        return connection.getResponseCode() == 200;
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        URL url = this.makeUrl(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.connect();
        this.debugConnection(connection);
        if (connection.getResponseCode() != 200) {
            throw new FileNotFoundException("could not find file: " + path);
        }
        long length = connection.getHeaderFieldInt("Content-Length", 0);
        length = length < 0L ? 0L : length;
        long modified = connection.getHeaderFieldDate("Last-Modified", System.currentTimeMillis());
        return new FileStatus(length, false, 1, this.getDefaultBlockSize(), modified, path);
    }

    private void debugConnection(HttpURLConnection connection) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connection.getURL() = {}", (Object)connection.getURL());
            LOG.debug("connection.getRequestMethod() = {}", (Object)connection.getRequestMethod());
            LOG.debug("connection.getResponseCode() = {}", (Object)connection.getResponseCode());
            LOG.debug("connection.getResponseMessage() = {}", (Object)connection.getResponseMessage());
            LOG.debug("connection.getContentLength() = {}", (Object)connection.getContentLength());
        }
    }

    private URL makeUrl(Path path) throws IOException {
        if (path.toString().startsWith(this.scheme)) {
            return URI.create(path.toString()).toURL();
        }
        try {
            return new URI(this.scheme, this.authority, path.toString(), null, null).toURL();
        }
        catch (URISyntaxException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
    }
}

