/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.MultiRecordReaderIterator;
import cascading.tap.hadoop.io.RecordReaderIterator;
import cascading.tap.hadoop.util.MeasuredRecordReader;
import cascading.tuple.TupleEntrySchemeIterator;
import cascading.util.CloseableIterator;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class HadoopTupleEntrySchemeIterator
extends TupleEntrySchemeIterator<JobConf, RecordReader> {
    private MeasuredRecordReader measuredRecordReader;

    public HadoopTupleEntrySchemeIterator(FlowProcess<JobConf> flowProcess, Tap parentTap, RecordReader recordReader) throws IOException {
        this(flowProcess, parentTap.getScheme(), HadoopTupleEntrySchemeIterator.makeIterator(flowProcess, parentTap, recordReader));
    }

    public HadoopTupleEntrySchemeIterator(FlowProcess<JobConf> flowProcess, Scheme scheme, CloseableIterator<RecordReader> closeableIterator) {
        super(flowProcess, scheme, closeableIterator, flowProcess.getStringProperty("cascading.source.path"));
    }

    private static CloseableIterator<RecordReader> makeIterator(FlowProcess<JobConf> flowProcess, Tap parentTap, RecordReader recordReader) throws IOException {
        if (recordReader != null) {
            return new RecordReaderIterator(recordReader);
        }
        return new MultiRecordReaderIterator(flowProcess, parentTap);
    }

    protected RecordReader wrapInput(RecordReader recordReader) {
        if (this.measuredRecordReader == null) {
            this.measuredRecordReader = new MeasuredRecordReader(this.getFlowProcess(), (Enum)SliceCounters.Read_Duration);
        }
        this.measuredRecordReader.setRecordReader(recordReader);
        return this.measuredRecordReader;
    }
}

