/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeCollector;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputLogFilter;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hfs
extends Tap<JobConf, RecordReader, OutputCollector> {
    private static final Logger LOG = LoggerFactory.getLogger(Hfs.class);
    public static final String TEMPORARY_DIRECTORY = "cascading.tmp.dir";
    public static final String LOCAL_MODE_SCHEME = "cascading.hadoop.localmode.scheme";
    protected String stringPath;
    transient URI uriScheme;
    transient Path path;
    private transient FileStatus[] statuses;

    public static void setTemporaryDirectory(Map<Object, Object> properties, String tempDir) {
        properties.put(TEMPORARY_DIRECTORY, tempDir);
    }

    public static String getTemporaryDirectory(Map<Object, Object> properties) {
        return (String)properties.get(TEMPORARY_DIRECTORY);
    }

    public static void setLocalModeScheme(Map<Object, Object> properties, String scheme) {
        properties.put(LOCAL_MODE_SCHEME, scheme);
    }

    protected static String getLocalModeScheme(JobConf conf, String defaultValue) {
        return conf.get(LOCAL_MODE_SCHEME, defaultValue);
    }

    protected Hfs() {
    }

    @ConstructorProperties(value={"scheme"})
    protected Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme) {
        super(scheme);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath"})
    public Hfs(Fields fields, String stringPath) {
        super((Scheme)new SequenceFile(fields));
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath", "replace"})
    public Hfs(Fields fields, String stringPath, boolean replace) {
        super((Scheme)new SequenceFile(fields), replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    public Hfs(Fields fields, String stringPath, SinkMode sinkMode) {
        super((Scheme)new SequenceFile(fields), sinkMode);
        this.setStringPath(stringPath);
        if (sinkMode == SinkMode.UPDATE) {
            throw new IllegalArgumentException("updates are not supported");
        }
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath) {
        super(scheme);
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath, boolean replace) {
        super(scheme, replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.setStringPath(stringPath);
    }

    protected void setStringPath(String stringPath) {
        this.stringPath = Util.normalizeUrl((String)stringPath);
    }

    protected void setUriScheme(URI uriScheme) {
        this.uriScheme = uriScheme;
    }

    public URI getURIScheme(JobConf jobConf) {
        if (this.uriScheme != null) {
            return this.uriScheme;
        }
        this.uriScheme = this.makeURIScheme(jobConf);
        return this.uriScheme;
    }

    protected URI makeURIScheme(JobConf jobConf) {
        try {
            URI uriScheme = null;
            LOG.debug("handling path: {}", (Object)this.stringPath);
            URI uri = new Path(this.stringPath).toUri();
            String schemeString = uri.getScheme();
            String authority = uri.getAuthority();
            if (LOG.isDebugEnabled()) {
                LOG.debug("found scheme: {}", (Object)schemeString);
                LOG.debug("found authority: {}", (Object)authority);
            }
            uriScheme = schemeString != null && authority != null ? new URI(schemeString + "://" + uri.getAuthority()) : (schemeString != null ? new URI(schemeString + ":///") : this.getDefaultFileSystemURIScheme(jobConf));
            LOG.debug("using uri scheme: {}", (Object)uriScheme);
            return uriScheme;
        }
        catch (URISyntaxException exception) {
            throw new TapException("could not determine scheme from path: " + this.getPath(), (Throwable)exception);
        }
    }

    public URI getDefaultFileSystemURIScheme(JobConf jobConf) {
        return this.getDefaultFileSystem(jobConf).getUri();
    }

    protected FileSystem getDefaultFileSystem(JobConf jobConf) {
        try {
            return FileSystem.get((Configuration)jobConf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to underlying filesystem", (Throwable)exception);
        }
    }

    protected FileSystem getFileSystem(JobConf jobConf) {
        URI scheme = this.getURIScheme(jobConf);
        try {
            return FileSystem.get((URI)scheme, (Configuration)jobConf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to get filesystem for: " + scheme.getScheme(), (Throwable)exception);
        }
    }

    public String getIdentifier() {
        return this.getPath().toString();
    }

    public Path getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.stringPath == null) {
            throw new IllegalStateException("path not initialized");
        }
        this.path = new Path(this.stringPath);
        return this.path;
    }

    public String getFullIdentifier(JobConf conf) {
        return this.getPath().makeQualified(this.getFileSystem(conf)).toString();
    }

    public void sourceConfInit(FlowProcess<JobConf> process, JobConf conf) {
        Path qualifiedPath = new Path(this.getFullIdentifier(conf));
        for (Path exitingPath : FileInputFormat.getInputPaths((JobConf)conf)) {
            if (!exitingPath.equals((Object)qualifiedPath)) continue;
            throw new TapException("may not add duplicate paths, found: " + exitingPath);
        }
        FileInputFormat.addInputPath((JobConf)conf, (Path)qualifiedPath);
        super.sourceConfInit(process, (Object)conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via source: ");
        TupleSerialization.setSerializations(conf);
    }

    public void sinkConfInit(FlowProcess<JobConf> process, JobConf conf) {
        Path qualifiedPath = new Path(this.getFullIdentifier(conf));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)qualifiedPath);
        super.sinkConfInit(process, (Object)conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via sink: ");
        TupleSerialization.setSerializations(conf);
    }

    private void makeLocal(JobConf conf, Path qualifiedPath, String infoMessage) {
        String scheme = Hfs.getLocalModeScheme(conf, "file");
        if (!conf.get("mapred.job.tracker", "").equalsIgnoreCase("local") && qualifiedPath.toUri().getScheme().equalsIgnoreCase(scheme)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(infoMessage + this.toString());
            }
            conf.set("mapred.job.tracker", "local");
        }
    }

    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader input) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, this, input);
    }

    public TupleEntryCollector openForWrite(FlowProcess<JobConf> flowProcess, OutputCollector output) throws IOException {
        return new HadoopTupleEntrySchemeCollector(flowProcess, this, output);
    }

    public boolean createResource(JobConf conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("making dirs: {}", (Object)this.getFullIdentifier(conf));
        }
        return this.getFileSystem(conf).mkdirs(this.getPath());
    }

    public boolean deleteResource(JobConf conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleting: {}", (Object)this.getFullIdentifier(conf));
        }
        if (new Path(this.getFullIdentifier(conf)).depth() == 0) {
            return true;
        }
        FileSystem fileSystem = this.getFileSystem(conf);
        try {
            return fileSystem.delete(this.getPath(), true);
        }
        catch (NullPointerException exception) {
            if (!(fileSystem instanceof NativeS3FileSystem)) {
                throw exception;
            }
            return true;
        }
    }

    public boolean resourceExists(JobConf conf) throws IOException {
        return this.getFileSystem(conf).exists(this.getPath());
    }

    public boolean isDirectory(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return false;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).isDir();
    }

    public long getSize(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0L;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).getLen();
    }

    public long getBlockSize(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0L;
        }
        return fileStatus.getBlockSize();
    }

    public int getReplication(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0;
        }
        return fileStatus.getReplication();
    }

    public String[] getChildIdentifiers(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return new String[0];
        }
        FileStatus[] statuses = this.getFileSystem(conf).listStatus(this.getPath(), (PathFilter)new OutputLogFilter());
        String[] children = new String[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            children[i] = statuses[i].getPath().toString();
        }
        return children;
    }

    public long getModifiedTime(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (!fileStatus.isDir()) {
            return fileStatus.getModificationTime();
        }
        this.makeStatuses(conf);
        if (this.statuses == null || this.statuses.length == 0) {
            return 0L;
        }
        long date = 0L;
        for (FileStatus status : this.statuses) {
            if (status.isDir()) continue;
            date = Math.max(date, status.getModificationTime());
        }
        return date;
    }

    public static Path getTempPath(JobConf conf) {
        String tempDir = conf.get(TEMPORARY_DIRECTORY);
        if (tempDir == null) {
            tempDir = conf.get("hadoop.tmp.dir");
        }
        return new Path(tempDir);
    }

    protected String makeTemporaryPathDirString(String name) {
        if ((name = name.replaceAll("^[_\\W\\s]+", "")).isEmpty()) {
            name = "temp-path";
        }
        return name.replaceAll("[\\W\\s]+", "_") + Util.createUniqueID();
    }

    private void makeStatuses(JobConf conf) throws IOException {
        if (this.statuses != null) {
            return;
        }
        this.statuses = this.getFileSystem(conf).listStatus(this.getPath());
    }
}

