/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;

public class Dfs
extends Hfs {
    @ConstructorProperties(value={"fields", "uri"})
    @Deprecated
    public Dfs(Fields fields, URI uri) {
        super(fields, uri.getPath());
        this.init(uri);
    }

    @ConstructorProperties(value={"fields", "uri", "replace"})
    @Deprecated
    public Dfs(Fields fields, URI uri, boolean replace) {
        super(fields, uri.getPath(), replace);
        this.init(uri);
    }

    @ConstructorProperties(value={"fields", "uri", "sinkMode"})
    @Deprecated
    public Dfs(Fields fields, URI uri, SinkMode sinkMode) {
        super(fields, uri.getPath(), sinkMode);
        this.init(uri);
    }

    @ConstructorProperties(value={"fields", "stringPath"})
    @Deprecated
    public Dfs(Fields fields, String stringPath) {
        super(fields, stringPath);
    }

    @ConstructorProperties(value={"fields", "stringPath", "replace"})
    @Deprecated
    public Dfs(Fields fields, String stringPath, boolean replace) {
        super(fields, stringPath, replace);
    }

    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    @Deprecated
    public Dfs(Fields fields, String stringPath, SinkMode sinkMode) {
        super(fields, stringPath, sinkMode);
    }

    @ConstructorProperties(value={"scheme"})
    Dfs(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"scheme", "uri"})
    public Dfs(Scheme scheme, URI uri) {
        super(scheme, uri.getPath());
        this.init(uri);
    }

    @ConstructorProperties(value={"scheme", "uri", "replace"})
    @Deprecated
    public Dfs(Scheme scheme, URI uri, boolean replace) {
        super(scheme, uri.getPath(), replace);
        this.init(uri);
    }

    @ConstructorProperties(value={"scheme", "uri", "sinkMode"})
    public Dfs(Scheme scheme, URI uri, SinkMode sinkMode) {
        super(scheme, uri.getPath(), sinkMode);
        this.init(uri);
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Dfs(Scheme scheme, String stringPath) {
        super(scheme, stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    @Deprecated
    public Dfs(Scheme scheme, String stringPath, boolean replace) {
        super(scheme, stringPath, replace);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Dfs(Scheme scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, stringPath, sinkMode);
    }

    private void init(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        this.setUriScheme(URI.create(uri.getScheme() + "://" + uri.getAuthority()));
    }

    @Override
    protected void setStringPath(String stringPath) {
        if (stringPath.matches(".*://.*") && !stringPath.startsWith("hdfs://")) {
            throw new IllegalArgumentException("uri must use the hdfs scheme");
        }
        super.setStringPath(stringPath);
    }

    @Override
    protected FileSystem getDefaultFileSystem(JobConf jobConf) {
        String name = jobConf.get("fs.default.name", "hdfs://localhost:5001/");
        if (name.equals("local") || name.matches(".*://.*") && !name.startsWith("hdfs://")) {
            name = "hdfs://localhost:5001/";
        } else if (name.indexOf(47) == -1) {
            name = "hdfs://" + name;
        }
        try {
            return FileSystem.get((URI)URI.create(name), (Configuration)jobConf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to get filesystem for: " + name, (Throwable)exception);
        }
    }
}

