/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.flow.FlowException;
import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopSliceStats;
import cascading.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopStepStats
extends FlowStepStats {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStepStats.class);
    private Map<TaskID, String> idCache = new HashMap<TaskID, String>(4999);
    int numMapTasks;
    int numReduceTasks;
    Map<String, HadoopSliceStats> taskStats = Collections.EMPTY_MAP;

    protected HadoopStepStats(FlowStep<JobConf> flowStep, ClientState clientState) {
        super(flowStep, clientState);
    }

    public Map<String, HadoopSliceStats> getTaskStats() {
        return this.taskStats;
    }

    protected void setTaskStats(Map<String, HadoopSliceStats> taskStats) {
        this.taskStats = taskStats;
    }

    public int getNumMapTasks() {
        return this.numMapTasks;
    }

    void setNumMapTasks(int numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public int getNumReduceTasks() {
        return this.numReduceTasks;
    }

    void setNumReduceTasks(int numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public String getJobID() {
        if (this.getRunningJob() == null) {
            return null;
        }
        return this.getRunningJob().getJobID();
    }

    public abstract JobClient getJobClient();

    public abstract RunningJob getRunningJob();

    public Collection<String> getCounterGroups() {
        try {
            RunningJob runningJob = this.getRunningJob();
            if (runningJob == null) {
                return Collections.emptySet();
            }
            Counters counters = runningJob.getCounters();
            if (counters == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableCollection(counters.getGroupNames());
        }
        catch (IOException exception) {
            throw new FlowException("unable to get remote counter groups");
        }
    }

    public Collection<String> getCounterGroupsMatching(String regex) {
        try {
            RunningJob runningJob = this.getRunningJob();
            if (runningJob == null) {
                return Collections.emptySet();
            }
            Counters counters = runningJob.getCounters();
            if (counters == null) {
                return Collections.emptySet();
            }
            HashSet<String> results = new HashSet<String>();
            for (String counter : counters.getGroupNames()) {
                if (!counter.matches(regex)) continue;
                results.add(counter);
            }
            return Collections.unmodifiableCollection(results);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get remote counter groups");
        }
    }

    public Collection<String> getCountersFor(String group) {
        try {
            RunningJob runningJob = this.getRunningJob();
            if (runningJob == null) {
                return Collections.emptySet();
            }
            Counters counters = runningJob.getCounters();
            if (counters == null) {
                return Collections.emptySet();
            }
            HashSet<String> results = new HashSet<String>();
            for (Counters.Counter counter : counters.getGroup(group)) {
                results.add(counter.getName());
            }
            return Collections.unmodifiableCollection(results);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get remote counter groups");
        }
    }

    public long getCounterValue(Enum counter) {
        try {
            RunningJob runningJob = this.getRunningJob();
            if (runningJob == null) {
                return 0L;
            }
            Counters counters = runningJob.getCounters();
            if (counters == null) {
                return 0L;
            }
            return counters.getCounter(counter);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get remote counter values");
        }
    }

    public long getCounterValue(String group, String counter) {
        try {
            RunningJob runningJob = this.getRunningJob();
            if (runningJob == null) {
                return 0L;
            }
            Counters counters = runningJob.getCounters();
            if (counters == null) {
                return 0L;
            }
            Counters.Group counterGroup = counters.getGroup(group);
            if (group == null) {
                return 0L;
            }
            Counters.Counter counterValue = counterGroup.getCounterForName(counter);
            if (counter == null) {
                return 0L;
            }
            return counterValue.getValue();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get remote counter values");
        }
    }

    public float getMapProgress() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.mapProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public float getReduceProgress() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return 0.0f;
        }
        try {
            return runningJob.reduceProgress();
        }
        catch (IOException exception) {
            throw new FlowException("unable to get progress");
        }
    }

    public String getStatusURL() {
        RunningJob runningJob = this.getRunningJob();
        if (runningJob == null) {
            return null;
        }
        return runningJob.getTrackingURL();
    }

    public Collection getChildren() {
        return this.getTaskStats().values();
    }

    public Set<String> getChildIDs() {
        return this.getTaskStats().keySet();
    }

    public synchronized void recordChildStats() {
        if (!this.clientState.isEnabled()) {
            return;
        }
        this.captureDetail();
        try {
            for (String id : this.taskStats.keySet()) {
                this.clientState.record(id, (Object)this.taskStats.get(id));
            }
        }
        catch (Exception exception) {
            LOG.error("unable to record slice stats", (Throwable)exception);
        }
    }

    public synchronized void captureDetail() {
        this.captureDetail(true);
    }

    public void captureDetail(boolean captureAttempts) {
        HashMap<String, HadoopSliceStats> newStats = new HashMap<String, HadoopSliceStats>();
        JobClient jobClient = this.getJobClient();
        RunningJob runningJob = this.getRunningJob();
        if (jobClient == null || runningJob == null) {
            return;
        }
        this.numMapTasks = 0;
        this.numReduceTasks = 0;
        try {
            TaskCompletionEvent[] events;
            this.addTaskStats(newStats, HadoopSliceStats.Kind.MAPPER, jobClient.getMapTaskReports(runningJob.getID()), false);
            this.addTaskStats(newStats, HadoopSliceStats.Kind.REDUCER, jobClient.getReduceTaskReports(runningJob.getID()), false);
            int count = 0;
            while (captureAttempts && (events = runningJob.getTaskCompletionEvents(count)).length != 0) {
                this.addAttemptsToTaskStats(newStats, events);
                count += events.length;
            }
            this.setTaskStats(newStats);
        }
        catch (IOException exception) {
            LOG.warn("unable to get task stats", (Throwable)exception);
        }
    }

    private void addTaskStats(Map<String, HadoopSliceStats> taskStats, HadoopSliceStats.Kind kind, TaskReport[] taskReports, boolean skipLast) {
        for (int i = 0; i < taskReports.length - (skipLast ? 1 : 0); ++i) {
            TaskReport taskReport = taskReports[i];
            if (taskReport == null) {
                LOG.warn("found empty task report");
                continue;
            }
            String id = this.getIDFor(taskReport.getTaskID());
            taskStats.put(id, new HadoopSliceStats(id, this.getStatus(), kind, this.stepHasReducers(), taskReport));
            this.incrementKind(kind);
        }
    }

    private boolean stepHasReducers() {
        return !this.getFlowStep().getGroups().isEmpty();
    }

    private void incrementKind(HadoopSliceStats.Kind kind) {
        switch (kind) {
            case SETUP: {
                break;
            }
            case MAPPER: {
                ++this.numMapTasks;
                break;
            }
            case REDUCER: {
                ++this.numReduceTasks;
                break;
            }
        }
    }

    private void addAttemptsToTaskStats(Map<String, HadoopSliceStats> taskStats, TaskCompletionEvent[] events) {
        for (TaskCompletionEvent event : events) {
            if (event == null) {
                LOG.warn("found empty completion event");
                continue;
            }
            HadoopSliceStats stats = taskStats.get(this.getIDFor(event.getTaskAttemptId().getTaskID()));
            if (stats == null) continue;
            stats.addAttempt(event);
        }
    }

    private String getIDFor(TaskID taskID) {
        String id = this.idCache.get(taskID);
        if (id == null) {
            id = Util.createID((String)taskID.toString());
            this.idCache.put(taskID, id);
        }
        return id;
    }
}

