/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class TextLine
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long serialVersionUID = 1L;
    public static final Fields DEFAULT_SOURCE_FIELDS = new Fields(new Comparable[]{"offset", "line"});
    Compress sinkCompression = Compress.DISABLE;
    String charsetName = "UTF-8";

    public TextLine() {
        super(DEFAULT_SOURCE_FIELDS);
    }

    @ConstructorProperties(value={"numSinkParts"})
    public TextLine(int numSinkParts) {
        super(DEFAULT_SOURCE_FIELDS, numSinkParts);
    }

    @ConstructorProperties(value={"sinkCompression"})
    public TextLine(Compress sinkCompression) {
        super(DEFAULT_SOURCE_FIELDS);
        this.setSinkCompression(sinkCompression);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields"})
    public TextLine(Fields sourceFields, Fields sinkFields) {
        super(sourceFields, sinkFields);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, String charsetName) {
        super(sourceFields, sinkFields);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression) {
        super(sourceFields, sinkFields);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, String charsetName) {
        super(sourceFields, sinkFields);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, int numSinkParts, String charsetName) {
        super(sourceFields, sinkFields, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields"})
    public TextLine(Fields sourceFields) {
        super(sourceFields);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "charsetName"})
    public TextLine(Fields sourceFields, String charsetName) {
        super(sourceFields);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "numSinkParts"})
    public TextLine(Fields sourceFields, int numSinkParts) {
        super(sourceFields, numSinkParts);
        this.verify(sourceFields);
    }

    private void setCharsetName(String charsetName) {
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
    }

    protected void verify(Fields sourceFields) {
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    public Compress getSinkCompression() {
        return this.sinkCompression;
    }

    public void setSinkCompression(Compress sinkCompression) {
        if (sinkCompression != null) {
            this.sinkCompression = sinkCompression;
        }
    }

    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (this.hasZippedFiles(FileInputFormat.getInputPaths((JobConf)conf))) {
            throw new IllegalStateException("cannot read zip files: " + Arrays.toString(FileInputFormat.getInputPaths((JobConf)conf)));
        }
        conf.setInputFormat(TextInputFormat.class);
    }

    private boolean hasZippedFiles(Path[] paths) {
        boolean isZipped = paths[0].getName().endsWith(".zip");
        for (int i = 1; i < paths.length; ++i) {
            if (isZipped == paths[i].getName().endsWith(".zip")) continue;
            throw new IllegalStateException("cannot mix zipped and upzipped files");
        }
        return isZipped;
    }

    public void presentSourceFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields) {
    }

    public void presentSinkFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields) {
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        if (tap.getFullIdentifier((Object)conf).toString().endsWith(".zip")) {
            throw new IllegalStateException("cannot write zip files: " + FileOutputFormat.getOutputPath((JobConf)conf));
        }
        if (this.getSinkCompression() == Compress.DISABLE) {
            conf.setBoolean("mapred.output.compress", false);
        } else if (this.getSinkCompression() == Compress.ENABLE) {
            conf.setBoolean("mapred.output.compress", true);
        }
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
    }

    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext((Object)new Object[3]);
        ((Object[])sourceCall.getContext())[0] = (Writable)((RecordReader)sourceCall.getInput()).createKey();
        ((Object[])sourceCall.getContext())[1] = (Writable)((RecordReader)sourceCall.getInput()).createValue();
        ((Object[])sourceCall.getContext())[2] = Charset.forName(this.charsetName);
    }

    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        if (!this.sourceReadInput(sourceCall)) {
            return false;
        }
        this.sourceHandleInput(sourceCall);
        return true;
    }

    private boolean sourceReadInput(SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = (Object[])sourceCall.getContext();
        return ((RecordReader)sourceCall.getInput()).next(context[0], context[1]);
    }

    protected void sourceHandleInput(SourceCall<Object[], RecordReader> sourceCall) {
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        int index = 0;
        Object[] context = (Object[])sourceCall.getContext();
        if (this.getSourceFields().size() == 2) {
            tuple.set(index++, (Object)((LongWritable)context[0]).get());
        }
        tuple.set(index, (Object)this.makeEncodedString(context));
    }

    protected String makeEncodedString(Object[] context) {
        Text text = (Text)context[1];
        return new String(text.getBytes(), 0, text.getLength(), (Charset)context[2]);
    }

    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext((Object)new Object[2]);
        ((Object[])sinkCall.getContext())[0] = new Text();
        ((Object[])sinkCall.getContext())[1] = Charset.forName(this.charsetName);
    }

    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[1];
        String line = sinkCall.getOutgoingEntry().getTuple().toString();
        text.set(line.getBytes(charset));
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
    }

    public static enum Compress {
        DEFAULT,
        ENABLE,
        DISABLE;

    }
}

