/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class TextDelimited
extends TextLine {
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected final DelimitedParser delimitedParser;
    private boolean skipHeader;
    private final boolean writeHeader;
    private String charsetName = "UTF-8";

    public TextDelimited() {
        this(Fields.ALL, null, "\t", null, null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter"})
    public TextDelimited(boolean hasHeader, String delimiter) {
        this(Fields.ALL, null, hasHeader, delimiter, null, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter", "quote"})
    public TextDelimited(boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, null, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, sinkCompression, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"fields"})
    public TextDelimited(Fields fields) {
        this(fields, null, "\t", null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter"})
    public TextDelimited(Fields fields, String delimiter) {
        this(fields, null, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter) {
        this(fields, null, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields, null, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter", "types"})
    public TextDelimited(Fields fields, String delimiter, Class[] types) {
        this(fields, null, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, Class[] types) {
        this(fields, null, hasHeader, hasHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types) {
        this(fields, null, skipHeader, writeHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types) {
        this(fields, null, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe, String charsetName) {
        this(fields, null, hasHeader, hasHeader, delimiter, true, quote, types, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter) {
        this(fields, sinkCompression, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types) {
        this(fields, sinkCompression, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types, boolean safe, String charsetName) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, null, types, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote"})
    public TextDelimited(Fields fields, String delimiter, String quote) {
        this(fields, null, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, String charsetName) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "strict", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, strict, quote, types, safe, DEFAULT_CHARSET);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "delimiter", "strict", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types, boolean safe, String charsetName) {
        super(sinkCompression);
        this.setSinkFields(fields);
        this.setSourceFields(fields);
        this.skipHeader = skipHeader;
        this.writeHeader = writeHeader;
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
        this.delimitedParser = new DelimitedParser(delimiter, quote, types, strict, safe, skipHeader, this.getSourceFields(), this.getSinkFields());
    }

    public boolean isSymmetrical() {
        return super.isSymmetrical() && this.skipHeader == this.writeHeader;
    }

    public void setSinkFields(Fields sinkFields) {
        super.setSinkFields(sinkFields);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    public void setSourceFields(Fields sourceFields) {
        super.setSourceFields(sourceFields);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        if (!this.skipHeader || !this.getSourceFields().isUnknown()) {
            return this.getSourceFields();
        }
        if (tap instanceof CompositeTap) {
            tap = (Tap)((CompositeTap)tap).getChildTaps().next();
        }
        tap = new Hfs(new TextLine(new Fields(new Comparable[]{"line"}), this.charsetName), tap.getFullIdentifier(flowProcess.getConfigCopy()));
        this.setSourceFields(this.delimitedParser.parseFirstLine(flowProcess, tap));
        return this.getSourceFields();
    }

    @Override
    public void presentSourceFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields) {
        this.presentSourceFieldsInternal(fields);
    }

    @Override
    public void presentSinkFields(FlowProcess<JobConf> flowProcess, Tap tap, Fields fields) {
        this.presentSinkFieldsInternal(fields);
    }

    @Override
    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = (Object[])sourceCall.getContext();
        if (!((RecordReader)sourceCall.getInput()).next(context[0], context[1])) {
            return false;
        }
        if (this.skipHeader && ((LongWritable)context[0]).get() == 0L && !((RecordReader)sourceCall.getInput()).next(context[0], context[1])) {
            return false;
        }
        Object[] split = this.delimitedParser.parseLine(this.makeEncodedString(context));
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        tuple.clear();
        tuple.addAll(split);
        return true;
    }

    @Override
    public void sinkPrepare(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext((Object)new Object[3]);
        ((Object[])sinkCall.getContext())[0] = new Text();
        ((Object[])sinkCall.getContext())[1] = new StringBuilder(4096);
        ((Object[])sinkCall.getContext())[2] = Charset.forName(this.charsetName);
        if (this.writeHeader) {
            Fields fields = sinkCall.getOutgoingEntry().getFields();
            this.write(sinkCall, (Iterable)fields);
        }
    }

    @Override
    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Tuple tuple = sinkCall.getOutgoingEntry().getTuple();
        this.write(sinkCall, (Iterable)tuple);
    }

    private void write(SinkCall<Object[], OutputCollector> sinkCall, Iterable value) throws IOException {
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        StringBuilder line = (StringBuilder)((Object[])sinkCall.getContext())[1];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[2];
        line = (StringBuilder)this.delimitedParser.joinLine(value, (Appendable)line);
        text.set(line.toString().getBytes(charset));
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
        line.setLength(0);
    }
}

