/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class SequenceFile
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Void> {
    protected SequenceFile() {
        super(null);
    }

    @ConstructorProperties(value={"fields"})
    public SequenceFile(Fields fields) {
        super(fields, fields);
    }

    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        conf.setInputFormat(SequenceFileInputFormat.class);
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
    }

    public void sourcePrepare(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        Object[] pair = new Object[]{((RecordReader)sourceCall.getInput()).createKey(), ((RecordReader)sourceCall.getInput()).createValue()};
        sourceCall.setContext((Object)pair);
    }

    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Tuple key = (Tuple)((Object[])sourceCall.getContext())[0];
        Tuple value = (Tuple)((Object[])sourceCall.getContext())[1];
        boolean result = ((RecordReader)sourceCall.getInput()).next((Object)key, (Object)value);
        if (!result) {
            return false;
        }
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        if (sourceCall.getIncomingEntry().getFields().isDefined()) {
            tuple.setAll(value);
        } else {
            tuple.clear();
            tuple.addAll(value);
        }
        return true;
    }

    public void sourceCleanup(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        ((OutputCollector)sinkCall.getOutput()).collect((Object)Tuple.NULL, (Object)sinkCall.getOutgoingEntry().getTuple());
    }
}

