/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.hadoop.stream.HadoopCoGroupGate;
import cascading.flow.hadoop.stream.HadoopGroupByGate;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.hadoop.stream.HadoopSinkStage;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.stream.Duct;
import cascading.flow.stream.Gate;
import cascading.flow.stream.SinkStage;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StepStreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.Group;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.tap.Tap;
import java.util.List;

public class HadoopReduceStreamGraph
extends StepStreamGraph {
    public HadoopReduceStreamGraph(HadoopFlowProcess flowProcess, HadoopFlowStep step) {
        super((FlowProcess)flowProcess, (BaseFlowStep)step);
        this.buildGraph();
        this.setTraps();
        this.setScopes();
        this.printGraph(step.getID(), "reduce", flowProcess.getCurrentSliceNum());
        this.bind();
    }

    protected void buildGraph() {
        Group group = this.step.getGroup();
        HadoopGroupGate rhsDuct = null;
        rhsDuct = group.isGroupBy() ? new HadoopGroupByGate(this.flowProcess, (GroupBy)group, SpliceGate.Role.source) : new HadoopCoGroupGate(this.flowProcess, (CoGroup)group, SpliceGate.Role.source);
        this.addHead((Duct)rhsDuct);
        this.handleDuct((FlowElement)group, (Duct)rhsDuct);
    }

    protected SinkStage createSinkStage(Tap element) {
        return new HadoopSinkStage(this.flowProcess, element);
    }

    protected Gate createCoGroupGate(CoGroup element) {
        throw new IllegalStateException("should not happen");
    }

    protected Gate createGroupByGate(GroupBy element) {
        throw new IllegalStateException("should not happen");
    }

    protected Gate createHashJoinGate(HashJoin join) {
        throw new IllegalStateException("should not happen");
    }

    protected boolean stopOnElement(FlowElement lhsElement, List<FlowElement> successors) {
        if (successors.isEmpty()) {
            if (!(lhsElement instanceof Tap)) {
                throw new IllegalStateException("expected a Tap instance");
            }
            return true;
        }
        return false;
    }
}

