/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.stream.Duct;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.pipe.Splice;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tap.hadoop.util.MeasuredOutputCollector;
import cascading.tuple.Tuple;
import java.util.Iterator;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class HadoopGroupGate
extends SpliceGate {
    protected HadoopGroupByClosure closure;
    protected OutputCollector collector;

    public HadoopGroupGate(FlowProcess flowProcess, Splice splice, SpliceGate.Role role) {
        super(flowProcess, splice, role);
    }

    public void bind(StreamGraph streamGraph) {
        this.allPrevious = this.getAllPreviousFor(streamGraph);
        if (this.role != SpliceGate.Role.sink) {
            this.next = this.getNextFor(streamGraph);
        }
    }

    public void prepare() {
        this.collector = new MeasuredOutputCollector(this.flowProcess, (Enum)SliceCounters.Write_Duration, ((HadoopFlowProcess)this.flowProcess).getOutputCollector());
    }

    public void start(Duct previous) {
        if (this.next != null) {
            super.start(previous);
        }
    }

    public void complete(Duct previous) {
        if (this.next != null) {
            super.complete(previous);
        }
    }

    public void run(Tuple key, Iterator values) {
        key = this.unwrapGrouping(key);
        this.closure.reset(key, values);
        values = this.splice.getJoiner().getIterator((JoinerClosure)this.closure);
        this.keyEntry.setTuple(this.closure.getGroupTuple(key));
        this.tupleEntryIterator.reset(new Iterator[]{values});
        this.next.receive((Duct)this, (Object)this.grouping);
    }

    protected abstract Tuple unwrapGrouping(Tuple var1);
}

